﻿#include "detailForm.h"
#include "ui_detailForm.h"
#include "DTools/util.h"
#include "preDefine.h"
#include "DTools/configManger.h"
#include "Control/flowControl.h"
#include "QsLog.h"

DetailForm::DetailForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DetailForm)
{
    ui->setupUi(this);
    connect(this, &DetailForm::processOrder, &FlowControl::GetInstance(), &FlowControl::onProcessOrder);
    connect(this, &DetailForm::processRejectOrder, &FlowControl::GetInstance(), &FlowControl::onProcessRejectOrder);
    connect(this, &DetailForm::processRepealOrder, &FlowControl::GetInstance(), &FlowControl::onProcessRepealOrder);
    m_rejectForm=NULL;
    m_refuseForm=NULL;
    _Init();
}

DetailForm::~DetailForm()
{
    delete ui;
}

void DetailForm::InitData(OrderObject *orderObject)
{
    m_orderObject = orderObject;
    // 恢复界面
    ui->detailTable0->clearContents();
    ui->detailTable0->setRowCount(0);
    ui->detailBtn2->show();

    ui->detailBtn3->show();
    ui->detailBtn1->hide();
    ui->detailBtn0->hide();
    // 初始化界面
    ui->detailLab0->setText(QString("[%1 # %2][%3][%4]").arg(QString::number(orderObject->orderIndex),orderObject->getChannelName(),
                                                        orderObject->getOrderStatusDec(),
                                                        orderObject->id));
    ui->detailLab1->setText(QString("%1:%2").arg(orderObject->consigneeName,orderObject->consigneePhone));
    ui->detailLab2->setText(orderObject->deliveryTime.isEmpty()? QString::fromLocal8Bit("立即送出") : orderObject->deliveryTime);
    ui->detailLab3->setText(orderObject->riderName.isEmpty() ? QString::fromLocal8Bit("暂未指定") : QString::fromLocal8Bit("[姓名]%1 [电话]%2")
                                                                            .arg(orderObject->riderName, orderObject->riderPhone));
//TODO
    ui->detailLab4->setText(Penny2Dollar(orderObject->totalPrice));
    ui->detailLab6->setText(orderObject->needInvoice? orderObject->invoiceTitle : QString::fromLocal8Bit("不需要发票"));
    ui->detailLab7->setText(orderObject->msr_no.length()? orderObject->msr_no : orderObject->customerId);  // MSR_NO
    ui->detailLab5->setText(QString("[%1]").arg(orderObject->memo));
    int i=0;
    for(; i<orderObject->proList.count(); i++)
    {
        ui->detailTable0->insertRow(i);
        ui->detailTable0->setItem(i, 0, new QTableWidgetItem(GetProductName(orderObject->proList.at(i))));  // 商品名
        ui->detailTable0->item(i, 0)->setTextAlignment(Qt::AlignCenter);
        ui->detailTable0->setItem(i, 1, new QTableWidgetItem(Penny2Dollar(orderObject->proList.at(i)->price)));  // 价格
        ui->detailTable0->item(i, 1)->setTextAlignment(Qt::AlignCenter);
        ui->detailTable0->setItem(i, 2, new QTableWidgetItem(QString::number(orderObject->proList.at(i)->qty)));  // 数量
        ui->detailTable0->item(i, 2)->setTextAlignment(Qt::AlignCenter);
    }
    // 新增配送费 + 打包费
    ui->detailTable0->insertRow(i);
    ui->detailTable0->setItem(i, 0, new QTableWidgetItem(QString::fromLocal8Bit("配送费")));  // 配送费
    ui->detailTable0->item(i, 0)->setTextAlignment(Qt::AlignCenter);
    ui->detailTable0->setItem(i, 1, new QTableWidgetItem(Penny2Dollar(orderObject->deliveryPrice)));  // 价格
    ui->detailTable0->item(i, 1)->setTextAlignment(Qt::AlignCenter);
    ui->detailTable0->setItem(i, 2, new QTableWidgetItem(QString::number(1)));  // 数量
    ui->detailTable0->item(i, 2)->setTextAlignment(Qt::AlignCenter);

    ui->detailTable0->insertRow(i+1);
    ui->detailTable0->setItem(i+1, 0, new QTableWidgetItem(QString::fromLocal8Bit("包装费")));  // 包装费
    ui->detailTable0->item(i+1, 0)->setTextAlignment(Qt::AlignCenter);
    ui->detailTable0->setItem(i+1, 1, new QTableWidgetItem(Penny2Dollar(orderObject->packageFee)));  // 价格
    ui->detailTable0->item(i+1, 1)->setTextAlignment(Qt::AlignCenter);
    ui->detailTable0->setItem(i+1, 2, new QTableWidgetItem(QString::number(1)));  // 数量
    ui->detailTable0->item(i+1, 2)->setTextAlignment(Qt::AlignCenter);

//TODO
//    QString records;
//    foreach(QString record, orderObject->records)
//    {
//        records.append(record+"\r\n");
//    }
//    ui->detailLabRecord->setText(records);

//    if(!ConfigManger::GetInstance().GetIsExistReEntryOrder())
//    {
//        ui->detailBtn0->hide();
//    }

    ui->detailBtn2->setText(GetOperNameByStatus(orderObject->orderStatus, true));
    ui->detailBtn2->setProperty("operation", GetOperByStatus(orderObject->orderStatus, true));
    ui->detailBtn2->setProperty("orderId", orderObject->id);
    if(orderObject->orderStatus != 1 && orderObject->orderStatus != 20 && orderObject->orderStatus != 2 && orderObject->orderStatus != 3 && orderObject->orderStatus != OrderObject::SimExcept)
    {
        ui->detailBtn2->hide();
    }
    //星巴克:如果订单是客诉单，不能显示退单按钮；
    if(3 == orderObject->getOrderType()){
        ui->detailBtn2->hide();
    }

    ui->detailBtn3->setText(GetOperNameByStatus(orderObject->orderStatus));
    ui->detailBtn3->setProperty("operation", GetOperByStatus(orderObject->orderStatus));
    ui->detailBtn3->setProperty("orderId", orderObject->id);

    if(!GetOperByStatus(orderObject->orderStatus).compare("NULL"))
    {
        ui->detailBtn3->hide();
    }
    if(m_rejectForm==NULL)
        m_rejectForm = new RejectForm(this);
    if(m_refuseForm==NULL)
        m_refuseForm = new RefuseForm(this);
#ifdef TODO
    ui->detailBtn3->hide();
#endif
}

void DetailForm::_Init()
{
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);

    setGeometry(((QWidget*)parent())->geometry());

    int tableWidth = this->width()/2 - 65;
    ui->detailTable0->setColumnWidth(0, tableWidth*5/9);
    ui->detailTable0->setColumnWidth(1, tableWidth*2/9);
    ui->detailTable0->setColumnWidth(2, tableWidth*2/9);
    ui->detailTable0->horizontalHeader()->setFixedHeight(25);
    ui->detailTable0->horizontalHeader()->setSectionResizeMode(QHeaderView::Fixed);
}

QString DetailForm::GetProductName(dishesObject *dish)
{
    QString name;
    QString propertyTags;
    name.append(dish->name).append("\r\n");
    propertyTags=dish->specId;
    if(!propertyTags.isEmpty())
    {
        name.append(QString("(%1)").arg(propertyTags));
    }

    if(!dish->sub_products.isEmpty())
    {
        foreach(auto value,dish->sub_products)
        {
            name.append(value->name).append("|");
        }
    }
    name.remove((name.length()-1),1);
    return name;
}

void DetailForm::onOperaBtnClicked()
{
    QLOG_INFO() << QString("[<<<<---DetailForm::onOperaBtnClicked: begin:--->>>>]");
    //hide(); //隐藏详情界面将会产生一种BUG: 在选择退货原因时，详情页面+主界面都隐藏了，即使不退货，点击取消，主程序也会崩溃(无dump文件)；
    //hide(); //为了友好用户的使用体验感，hide() 还是需要在接受完取消订单原因后，再隐藏；
    QPushButton *pBtn = (QPushButton*)sender();
    if(pBtn->text()==QString::fromLocal8Bit("拒单")||pBtn->text()==QString::fromLocal8Bit("退单"))
    {
        m_refuseForm->SetOrderInfo(m_orderObject);
        m_refuseForm->show();
        QLOG_INFO() << QString("[<<<<---DetailForm::onOperaBtnClicked: QPushButton:--->>>>]")<<pBtn->text();
        if(m_refuseForm->exec()==QDialog::Accepted)
        {
            QLOG_INFO() << QString("[<<<<---DetailForm::onOperaBtnClicked: m_refuseForm->exec()==QDialog::Accepted--->>>>]");
            QLOG_INFO() << QString("[<<<<---DetailForm::onOperaBtnClicked: --->>>>]")<<m_refuseForm->m_reasonCode<<m_refuseForm->m_reasonStr<<m_refuseForm->m_refundDishesListString;
            emit processRepealOrder( pBtn->property("orderId").toString(),m_refuseForm->m_reasonCode,m_refuseForm->m_reasonStr,m_refuseForm->m_refundDishesListString);
            hide(); //为了友好用户的使用体验感，hide() 还是需要在接受完取消订单原因后，再隐藏；
        }
    } else {
        emit processOrder(pBtn->property("operation").toString(), pBtn->property("orderId").toString());
    }

}

void DetailForm::on_detailBtn1_clicked()
{
}
