﻿#include "dailyreportForm.h"
#include "ui_dailyreportForm.h"
#include <QPainter>
#include "preDefine.h"
#include "Model/dailyobject.h"
#include <QJsonArray>
#include <QJsonValue>
#include <QDebug>

DailyReportForm::DailyReportForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DailyReportForm)
{
    ui->setupUi(this);
    _Init();
}

DailyReportForm::~DailyReportForm()
{
    delete ui;
}

void DailyReportForm::on_btn_close_clicked()
{
    this->accept();
    return;
}

void DailyReportForm::CountFee(double& salesOrdersNum,double& salesOrdersSum,
                               double& refundsOrdersNum,double& refundsOrdersSum,const QJsonObject& json)
{
    salesOrdersNum=json[JSON_TOTALNUM].toInt();
    salesOrdersSum=json[JSON_TOTALFEE].toDouble()/100.0;
    refundsOrdersNum=json[JSON_REFUNDTOTALNUM].toInt();
    refundsOrdersSum=json[JSON_REFUNDTOTALFEE].toDouble()/100.0;
    salesOrdersNumTotal+=salesOrdersNum;
    salesOrdersSumTotal+=salesOrdersSum;
    refundsOrdersNumTotal+=refundsOrdersNum;
    refundsOrdersSumTotal+=refundsOrdersSum;
    entrySuccessNum+=json[JSON_SUCCESSNUM].toInt();
    entrySuccessSum+=json[JSON_SUCCESSSUM].toDouble()/100.0;
    entryFailedNum+=json[JSON_FAILEDNUM].toInt();
    entryFailedSum+=json[JSON_FAILEDSUM].toDouble()/100.0;
}

void DailyReportForm::_Init()
{
    this->setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    this->setGeometry(((QWidget*)parent())->geometry());
    this->setAttribute(Qt::WA_TranslucentBackground, true);
    ui->btn_confirm->hide();
    ui->btn_print->hide();
}

void DailyReportForm::_SetChannelData(QJsonObject json)
{
    QString channel=json[JSON_CHANNEL].toString();
    double salesOrdersNum,salesOrdersSum;
    double refundsOrdersNum,refundsOrdersSum;
    if(!channel.compare("eleme"))
    {
        CountFee(salesOrdersNum,salesOrdersSum,refundsOrdersNum,refundsOrdersSum,json);
        ui->label_writeSalesOrdersNumELM->setText(QString::number(salesOrdersNum));
        ui->label_writeSalesOrdersSumELM->setText(QString::number(salesOrdersSum));
        ui->label_writeRefundsOrdersNumELM->setText(QString::number(refundsOrdersNum));
        ui->label_writeRefundsOrdersSumELM->setText(QString::number(refundsOrdersSum));
    }
    if(!channel.compare("mtwm"))
    {
        CountFee(salesOrdersNum,salesOrdersSum,refundsOrdersNum,refundsOrdersSum,json);
        ui->label_writeSalesOrdersNumMT->setText(QString::number(salesOrdersNum));
        ui->label_writeSalesOrdersSumMT->setText(QString::number(salesOrdersSum));
        ui->label_writeRefundsOrdersNumMT->setText(QString::number(refundsOrdersNum));
        ui->label_writeRefundsOrdersSumMT->setText(QString::number(refundsOrdersSum));
    }
    if(!channel.compare("bdwm"))
    {
        CountFee(salesOrdersNum,salesOrdersSum,refundsOrdersNum,refundsOrdersSum,json);
        ui->label_writeSalesOrdersNumBD->setText(QString::number(salesOrdersNum));
        ui->label_writeSalesOrdersSumBD->setText(QString::number(salesOrdersSum));
        ui->label_writeRefundsOrdersNumBD->setText(QString::number(refundsOrdersNum));
        ui->label_writeRefundsOrdersSumBD->setText(QString::number(refundsOrdersSum));
    }
    if(!channel.compare("jdwm"))
    {

        CountFee(salesOrdersNum,salesOrdersSum,refundsOrdersNum,refundsOrdersSum,json);
        ui->label_writeSalesOrdersNumJD->setText(QString::number(salesOrdersNum));
        ui->label_writeSalesOrdersSumJD->setText(QString::number(salesOrdersSum));
        ui->label_writeRefundsOrdersNumJD->setText(QString::number(refundsOrdersNum));
        ui->label_writeRefundsOrdersSumJD->setText(QString::number(refundsOrdersSum));
    }
    if(!channel.compare("fmwd"))
    {
        CountFee(salesOrdersNum,salesOrdersSum,refundsOrdersNum,refundsOrdersSum,json);
        ui->label_writeSalesOrdersNumFM->setText(QString::number(salesOrdersNum));
        ui->label_writeSalesOrdersSumFM->setText(QString::number(salesOrdersSum));
        ui->label_writeRefundsOrdersNumFM->setText(QString::number(refundsOrdersNum));
        ui->label_writeRefundsOrdersSumFM->setText(QString::number(refundsOrdersSum));
    }
    ui->label_writeSalesOrdersNumTotal->setText(QString::number(salesOrdersNumTotal));
    ui->label_writeSalesOrdersSumTotal->setText(QString::number(salesOrdersSumTotal));
    ui->label_writeRefundsOrdersNumTotal->setText(QString::number(refundsOrdersNumTotal));
    ui->label_writeRefundsOrdersSumTotal->setText(QString::number(refundsOrdersSumTotal));

    ui->label_writeEntrySuccessNum->setText(QString::number(entrySuccessNum-refundsOrdersNumTotal));
    ui->label_writeEntrySuccessSum->setText(QString::number(entrySuccessSum-refundsOrdersSumTotal));
    ui->label_writeEntryFailedNum->setText(QString::number(entryFailedNum));
    ui->label_writeEntryFailedSum->setText(QString::number(entryFailedSum));

    ui->label_writeRealPrice->setText(QString::number(salesOrdersSumTotal-refundsOrdersSumTotal));
}

void DailyReportForm::paintEvent(QPaintEvent *event)
{
    qDebug()<<event;
    QPainter painter(this);
    painter.fillRect(this->rect(), QColor(0, 0, 0, 70));  //QColor最后一个参数80代表背景的透明度
}

void DailyReportForm::Initdata(QJsonObject json)
{
//    salesOrdersNumTotal=0,      salesOrdersSumTotal=0.0;
//    refundsOrdersNumTotal=0,    refundsOrdersSumTotal=0.0;
//    entrySuccessNum=0,          entrySuccessSum=0.0;
//    entryFailedNum=0,           entryFailedSum=0.0;
//    ui->label_businessday->setText(QString("日结(<font color='#ff0000'>当前营业日：%1</font>)").arg(json[JSON_BUSINESSDATE].toString()));
//    ui->lable_storeName->setText(json[JSON_STORENAME].toString());
//    ui->label_writePosNo->setText(json[JSON_STATIONID].toString());
//    QString storeId=json[JSON_STOREID].toString().remove(0,7);
//    ui->label_writeStoreId->setText(storeId);
//    ui->label_writeDateTime->setText(json[JSON_BUSINESSDATE].toString());
//    ui->label_writeCashier->setText(json[JSON_OPERATORID].toString());
//    QJsonArray dailyArray=json[JSON_DAILYSUMMARYS].toArray();
//    foreach (QJsonValue value, dailyArray) {
//        QJsonObject obj=value.toObject();
//        _SetChannelData(obj);
//    }
}
