﻿#include "productObject.h"
#include <QJsonArray>

void ProductObject::FromJson(const QJsonObject &json)
{
    qDeleteAll(sub_products);
    sub_products.clear();
    FetchDataFromJson(json);
    QJsonArray products = json["sub_products"].toArray();
    foreach(QJsonValue product, products)
    {
        QJsonObject proJson = product.toObject();
        ProductObject *proObject = new ProductObject(this);
        proObject->FetchDataFromJson(proJson);
        sub_products.append(proObject);
    }
}

QString ProductObject::getPid() const
{
    return pid;
}
void ProductObject::setPid(const QString &v)
{
    pid = v;
}

QString ProductObject::getName() const
{
    return name;
}
void ProductObject::setName(const QString &v)
{
    name = v;
}

QString ProductObject::getupc() const
{
    return upc;
}
void ProductObject::setupc(const QString &v)
{
    upc = v;
}

int ProductObject::getprice() const
{
    return price;
}
void ProductObject::setprice(const int &v)
{
    price = v;
}

int ProductObject::getProductAmount() const
{
    return productAmount;
}
void ProductObject::setProductAmount(const int &v)
{
    productAmount = v;
}
