﻿#ifndef ORDEROBJECT_H
#define ORDEROBJECT_H

#include "Model/baseObject.h"
#include "Model/dishesObject.h"


class OrderObject : public QObject
{
    Q_OBJECT


    Q_PROPERTY (QString id READ getId WRITE setId)
    Q_PROPERTY (QString payfmId READ getPayfmId WRITE setPayfmId)
    Q_PROPERTY (QString thirdPartyBatch READ getThirdPartyBatch WRITE setThirdPartyBatch)
    Q_PROPERTY (int orderType READ getOrderType WRITE setOrderType)
    Q_PROPERTY (QString orgOrderId READ getOrgOrderId WRITE setOrgOrderId)
    Q_PROPERTY (QString waybillId READ getWaybillId WRITE setWaybillId)
    Q_PROPERTY (QString watercourseId READ getWatercourseId WRITE setWatercourseId)
    Q_PROPERTY (QString pickupCode READ getPickupCode WRITE setPickupCode)
    Q_PROPERTY (QString customerId READ getCustomerId WRITE setCustomerId)
    Q_PROPERTY (QString customerName READ getCustomerName WRITE setCustomerName)
    Q_PROPERTY (QString phone READ getPhone WRITE setPhone)

    Q_PROPERTY (QString msr_no READ getMsr_no WRITE setMsr_no)
    Q_PROPERTY (QString storeId READ getStoreId WRITE setStoreId)
    Q_PROPERTY (QString storeName READ getStoreName WRITE setStoreName)
    Q_PROPERTY (QString storeAddress READ getStoreAddress WRITE setStoreAddress)
    Q_PROPERTY (QString channel READ getChannel WRITE setChannel)
    Q_PROPERTY (int payWay READ getPayWay WRITE setPayWay)
    Q_PROPERTY (QString deliveryTime READ getDeliveryTime WRITE setDeliveryTime)
    Q_PROPERTY (QString riderName READ getRiderName WRITE setRiderName)
    Q_PROPERTY (QString riderPhone READ getRiderPhone WRITE setRiderPhone)
    Q_PROPERTY (QString createTime READ getCreateTime WRITE setCreateTime)
    Q_PROPERTY (QString confirmTime READ getConfirmTime WRITE setConfirmTime)
    Q_PROPERTY (QString sendTime READ getSendTime WRITE setSendTime)
    Q_PROPERTY (QString finishTime READ getFinishTime WRITE setFinishTime)
    Q_PROPERTY (QString cancelTime READ getCancelTime WRITE setCancelTime)
    Q_PROPERTY (QString cancelReason READ getCancelReason WRITE setCancelReason)
    Q_PROPERTY (QString memo READ getMemo WRITE setMemo)
    Q_PROPERTY (QString invoiceType READ getInvoiceType WRITE setInvoiceType)
    Q_PROPERTY (QString invoiceTitle READ getInvoiceTitle WRITE setInvoiceTitle)
    Q_PROPERTY (QString invoiceTaxpayerId READ getInvoiceTaxpayerId WRITE setInvoiceTaxpayerId)
    Q_PROPERTY (QString firstName READ getFirstName WRITE setFirstName)
    Q_PROPERTY (QString lastName READ getLastName WRITE setLastName)
    Q_PROPERTY (QString longitude READ getLongitude WRITE setLongitude)
    Q_PROPERTY (QString latitude READ getLatitude WRITE setLatitude)
    Q_PROPERTY (QString street READ getStreet WRITE setStreet)
    Q_PROPERTY (QString consigneeName READ getConsigneeName WRITE setConsigneeName)
    Q_PROPERTY (QString consigneePhone READ getConsigneePhone WRITE setConsigneePhone)
    Q_PROPERTY (QString addressDetail READ getAddressDetail WRITE setAddressDetail)
    Q_PROPERTY (QString posCheckNo READ getPosCheckNo WRITE setPosCheckNo)
    Q_PROPERTY (int updateTime READ getUpdateTime WRITE setUpdateTime)
    Q_PROPERTY (int needInvoice READ getNeedInvoice WRITE setNeedInvoice)
    Q_PROPERTY (int deliveryPrice READ getDeliveryPrice WRITE setDeliveryPrice)
    Q_PROPERTY (int packageFee READ getPackageFee WRITE setPackageFee)
    Q_PROPERTY (int productPrice READ getProductPrice WRITE setProductPrice)
    Q_PROPERTY (int totalPrice READ getTotalPrice WRITE setTotalPrice)
    Q_PROPERTY (int orderStatus READ getOrderStatus WRITE setOrderStatus)
    Q_PROPERTY (int deliveryStatus READ getDeliveryStatus WRITE setDeliveryStatus)
    Q_PROPERTY (int payStatus READ getPayStatus WRITE setPayStatus)
    Q_PROPERTY (int refundStatus READ getRefundStatus WRITE setRefundStatus)
    Q_PROPERTY (int deliveryChannel READ getDeliveryChannel WRITE setDeliveryChannel)
    Q_PROPERTY (QString customerSex READ getCustomerSex WRITE setCustomerSex)
    Q_PROPERTY (int orderIndex READ getOrderIndex WRITE setOrderIndex)
public:
    OrderObject(QObject *parent=0)
        :QObject(parent){}
    OrderObject(const OrderObject& order,QObject* parent);
    OrderObject& operator =(const OrderObject& order);

    typedef enum {
        NewOrder=2,Confirmed,Sendout,Finished,Refunded,RequestRefund
        ,Locked=-1,AgreeRefund=30,RefuseRefund=40 ,SimExcept=50
        /*,Refunded=6  Cancled=6(订单状态是6时，是退单); 退单目前本佳那边不区分*/
    }OrderStatus;

    /* 功能:从Json对象初获取数据
     * 参数:[1]JSon对象
     * 返回:NULL
     * */
    void FromJson(const QJsonObject &json);
    void FetchDataFromJson(const QJsonObject& json);
    QList<dishesObject*>proList;

public:



    QString id;  //编号
    QString payfmId;  //FM唯一码
    QString thirdPartyBatch ;  //第三方交易流水号
    int orderType; //订单类型: 用来区分是 正常订单(1) 预订单(2) 还是 客诉单:3 (星巴克定义客诉单的类型:12);
    QString orgOrderId; //原始订单编号
    QString waybillId ;  //运单号
    QString watercourseId; //流水号
    QString pickupCode; //取餐号
    QString customerId; //用户编号
    QString customerName;//用户名称
    QString posCheckNo; // POS小票号
    QString phone;
    QString msr_no;  //msr卡号
    QString storeId;
    QString storeName;
    QString storeAddress;
    QString channel;   //订单渠道: 1 星巴克APP 2饿了么APP 3 客诉单;
    int payWay;
    QString deliveryTime; //配送时间
    QString riderName; //骑手名
    QString riderPhone; //骑手电话
    QString createTime;
    QString confirmTime;
    QString sendTime;
    QString finishTime;
    QString cancelTime;
    QString cancelReason;
    QString memo;
    QString invoiceType;
    QString invoiceTitle;
    QString invoiceTaxpayerId;
    QString firstName; //用户名字；
    QString lastName;  //用户姓；
    QString longitude;
    QString latitude;
    QString street;
    QString consigneeName; //收货人名
    QString consigneePhone; //收货电话
    QString addressDetail;
    int orderIndex;
    int updateTime;
    QString customerSex; //用户性别 1-	男2-	女
    int needInvoice;
    int deliveryPrice;   // 配送费
    int packageFee;      // 打包费
    int productPrice;
    int totalPrice;
    int orderStatus;
    int deliveryStatus;
    int payStatus;
    int refundStatus;
    int deliveryChannel;
    int pushOrderType;
    int pushOrderTimes;
    bool isPush;
    bool isCancle;
    QString getChannelName();

    QString getOrderStatusDec();

    inline QString getId()const{return id;}
    inline void setId(const QString& v){id = v;}

    inline QString getPayfmId()const{return payfmId;}
    inline void setPayfmId(const QString& v){payfmId = v;}

    inline QString getThirdPartyBatch()const{return thirdPartyBatch;}
    inline void setThirdPartyBatch(const QString& v){thirdPartyBatch = v;}


    inline int getOrderType()const{return orderType;}
    inline void setOrderType(const int& v){orderType = v;}

    inline QString getOrgOrderId()const{return orgOrderId;}
    inline void setOrgOrderId(const QString& v){orgOrderId = v;}

    inline QString getWaybillId()const{return waybillId;}
    inline void setWaybillId(const QString& v){waybillId = v;}

    inline QString getWatercourseId()const{return watercourseId;}
    inline void setWatercourseId(const QString& v){watercourseId = v;}

    inline QString getPickupCode()const{return pickupCode;}
    inline void setPickupCode(const QString& v){pickupCode = v;}

    inline QString getCustomerId()const{return customerId;}
    inline void setCustomerId(const QString& v){customerId = v;}

    inline QString getCustomerName()const{return customerName;}
    inline void setCustomerName(const QString& v){customerName = v;}

    inline QString getPhone()const{return phone;}
    inline void setPhone(const QString& v){phone = v;}

    inline QString getMsr_no()const{return msr_no;}
    inline void setMsr_no(const QString& v){msr_no = v;}

    inline QString getStoreId()const{return storeId;}
    inline void setStoreId(const QString& v){storeId = v;}

    inline QString getStoreName()const{return storeName;}
    inline void setStoreName(const QString& v){storeName = v;}

    inline QString getStoreAddress()const{return storeAddress;}
    inline void setStoreAddress(const QString& v){storeAddress = v;}

    inline QString getChannel()const{return channel;}
    inline void setChannel(const QString& v){channel = v;}

    inline int getPayWay()const{return payWay;}
    inline void setPayWay(const int& v){payWay = v;}

    inline QString getDeliveryTime()const{return deliveryTime;}
    inline void setDeliveryTime(const QString& v){deliveryTime = v;}

    inline QString getRiderName()const{return riderName;}
    inline void setRiderName(const QString& v){riderName = v;}

    inline QString getRiderPhone()const{return riderPhone;}
    inline void setRiderPhone(const QString& v){riderPhone = v;}

    inline QString getCreateTime()const{return createTime;}
    inline void setCreateTime(const QString& v){createTime = v;}

    inline QString getConfirmTime()const{return confirmTime;}
    inline void setConfirmTime(const QString& v){confirmTime = v;}

    inline QString getSendTime()const{return sendTime;}
    inline void setSendTime(const QString& v){sendTime = v;}

    inline QString getFinishTime()const{return finishTime;}
    inline void setFinishTime(const QString& v){finishTime = v;}

    inline QString getCancelTime()const{return cancelTime;}
    inline void setCancelTime(const QString& v){cancelTime = v;}

    inline QString getCancelReason()const{return cancelReason;}
    inline void setCancelReason(const QString& v){cancelReason = v;}

    inline QString getMemo()const{return memo;}
    inline void setMemo(const QString& v){memo = v;}

    inline QString getInvoiceType()const{return invoiceType;}
    inline void setInvoiceType(const QString& v){invoiceType = v;}

    inline QString getInvoiceTitle()const{return invoiceTitle;}
    inline void setInvoiceTitle(const QString& v){invoiceTitle = v;}

    inline QString getInvoiceTaxpayerId()const{return invoiceTaxpayerId;}
    inline void setInvoiceTaxpayerId(const QString& v){invoiceTaxpayerId = v;}

    inline QString getFirstName()const{return firstName;}
    inline void setFirstName(const QString& v){firstName = v;}

    inline QString getLastName()const{return lastName;}
    inline void setLastName(const QString& v){lastName = v;}

    inline QString getLongitude()const{return longitude;}
    inline void setLongitude(const QString& v){longitude = v;}

    inline QString getLatitude()const{return latitude;}
    inline void setLatitude(const QString& v){latitude = v;}

    inline QString getStreet()const{return street;}
    inline void setStreet(const QString& v){street = v;}

    inline QString getConsigneeName()const{return consigneeName;}
    inline void setConsigneeName(const QString& v){consigneeName = v;}

    inline QString getConsigneePhone()const{return consigneePhone;}
    inline void setConsigneePhone(const QString& v){consigneePhone = v;}

    inline QString getAddressDetail()const{return addressDetail;}
    inline void setAddressDetail(const QString& v){addressDetail = v;}

    inline QString getPosCheckNo()const{return posCheckNo;}
    inline void setPosCheckNo(const QString& v){posCheckNo = v;}

    inline int getOrderIndex()const{return orderIndex;}
    inline void setOrderIndex(const int& v){orderIndex = v;}

    inline int getUpdateTime()const{return updateTime;}
    inline void setUpdateTime(const int& v){updateTime = v;}

    inline int getNeedInvoice()const{return needInvoice;}
    inline void setNeedInvoice(const int& v){needInvoice = v;}

    inline int getDeliveryPrice()const{return deliveryPrice;}
    inline void setDeliveryPrice(const int& v){deliveryPrice = v;}

    inline int getPackageFee()const{return packageFee;}
    inline void setPackageFee(const int& v){packageFee = v;}

    inline int getProductPrice()const{return productPrice;}
    inline void setProductPrice(const int& v){productPrice = v;}

    inline int getTotalPrice()const{return totalPrice;}
    inline void setTotalPrice(const int& v){totalPrice = v;}

    inline int getOrderStatus()const{return orderStatus;}
    inline void setOrderStatus(const int& v){orderStatus = v;}

    inline int getDeliveryStatus()const{return deliveryStatus;}
    inline void setDeliveryStatus(const int& v){deliveryStatus = v;}

    inline int getPayStatus()const{return payStatus;}
    inline void setPayStatus(const int& v){payStatus = v;}

    inline int getDeliveryChannel()const{return deliveryChannel;}
    inline void setDeliveryChannel(const int& v){deliveryChannel = v;}

    inline int getRefundStatus()const{return refundStatus;}
    inline void setRefundStatus(const int& v){refundStatus = v;}

    inline QString getCustomerSex()const{return customerSex;}
    inline void setCustomerSex(const QString& v){customerSex = v;}
};





#endif // ORDEROBJECT_H
