﻿#include "orderObject.h"
#include "preDefine.h"
#include "QsLog.h"
#include <QJsonArray>
OrderObject::OrderObject(const OrderObject &order, QObject *parent):QObject(parent)
{
    qDeleteAll(proList);
    proList.clear();
    const QMetaObject *m = order.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = order.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    foreach (auto ptr, order.proList) {
        dishesObject *product=new dishesObject(*ptr,this);
        this->proList.append(product);
    }
}

OrderObject& OrderObject::operator =(const OrderObject& order)
{
    qDeleteAll(proList);
    proList.clear();
    const QMetaObject *m = order.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = order.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    foreach (auto ptr, order.proList) {
        dishesObject *product=new dishesObject(*ptr,this);
        this->proList.append(product);
    }
    return *this;
}

void OrderObject::FromJson(const QJsonObject &json)
{
    qDeleteAll(proList);
    proList.clear();
    FetchDataFromJson(json);
    QJsonArray products = json[JSON_PRODUCTS].toArray();
    foreach(QJsonValue product, products)
    {
        QJsonObject proJson = product.toObject();
        dishesObject *proObject = new dishesObject(this);
        proObject->FetchDataFromJson(proJson);
        proList.append(proObject);
    }
    return;
}

void OrderObject::FetchDataFromJson(const QJsonObject &json)
{
    QStringList keys = json.keys();
    foreach(QString key, keys)
    {
        setProperty(key.toUtf8(), json[key].toVariant());
    }

    return;
}

QString OrderObject::getChannelName()
{
    QLOG_INFO() << QString("[<<<<---OrderObject:getChannelName [%3]--->>>>]").arg(channel);
    if ("MOD" == channel){
        return QString::fromLocal8Bit("星巴克");
    }else if("ELE" == channel){
        return QString::fromLocal8Bit("饿了么");
    }else if("BAIDU" == channel){
        return QString::fromLocal8Bit("百度外卖");
    }else if(3 == orderType){
        return QString::fromLocal8Bit("客诉单");
    }
    else{
        return QString::fromLocal8Bit("未知");
    }
}

QString OrderObject::getOrderStatusDec()
{
    switch(orderStatus)
    {
        case 1:return QString::fromLocal8Bit("下单待支付");
        case 2:return QString::fromLocal8Bit("已支付");
        case 3:return QString::fromLocal8Bit("接单");
        case 4:return QString::fromLocal8Bit("配送中");
        case 5:return QString::fromLocal8Bit("完成");
        case 6:return QString::fromLocal8Bit("取消");
        deafult: return QString::fromLocal8Bit("未知");
    }
    return QString::fromLocal8Bit("未知");
}
