﻿#ifndef DISHESOBJECT_H
#define DISHESOBJECT_H
#include <QObject>
#include <QJsonObject>
#include <QVariant>
#include <QMetaProperty>
class dishesObject : public QObject
{
    Q_OBJECT
    Q_PROPERTY (QString id READ getId WRITE setId)
    Q_PROPERTY (QString specId READ getspecId WRITE setspecId)
    Q_PROPERTY (QString name READ getname WRITE setname)
    Q_PROPERTY (QString specName READ getspecName WRITE setspecName)
    Q_PROPERTY (QString code READ getcode WRITE setcode)
    Q_PROPERTY (int packagePrice READ getpackagePrice WRITE setpackagePrice)
    Q_PROPERTY (int qty READ getqty WRITE setqty)
    Q_PROPERTY (int price READ getprice WRITE setprice)
    Q_PROPERTY (QString options READ getoptions WRITE setoptions)

public:
    explicit dishesObject(QObject *parent = 0):QObject(parent){}
    dishesObject(const dishesObject& dish,QObject* parent=0);
    dishesObject& operator =(const dishesObject& dish);
    void FetchDataFromJson(const QJsonObject &json);
    QString id;
    QString name;
    QString specId;
    QString specName;
    QString code;
    int qty;
    int packagePrice;
    int price;
    QString options;
    QList<dishesObject*> sub_products;

protected:
    inline QString getId(){ return id; }
    inline void setId(const QString& v){ id = v; }

    inline QString getspecId(){ return specId; }
    inline void setspecId(const QString& v){ specId = v; }

    inline QString getname(){ return name; }
    inline void setname(const QString& v){ name = v; }

    inline int getprice(){ return price; }
    inline void setprice(const int& v){ price = v; }

    inline QString getoptions(){ return options; }
    inline void setoptions(const QString& v){ options = v; }

    inline int getpackagePrice(){ return packagePrice; }
    inline void setpackagePrice(const int& v){ packagePrice = v; }

    inline QString getspecName(){ return specName; }
    inline void setspecName(const QString& v){ specName = v; }

    inline QString getcode(){ return code; }
    inline void setcode(const QString& v){ code = v; }

    inline int getqty(){ return qty; }
    inline void setqty(const int& v){ qty = v; }
};

#endif // DISHESOBJECT_H
