﻿#include "refuseForm.h"
#include "ui_refuseForm.h"
#include <QDebug>
#include "QsLog.h"

RefuseForm::RefuseForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RefuseForm),
    m_orderObject(NULL)
{
    ui->setupUi(this);
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    this->setModal(true);
    ui->refuseBtnOk->setEnabled(false);

    m_refDishesForm = new refDishesForm(this);
    ui->reasonNULL->hide();

}

RefuseForm::~RefuseForm()
{
    delete ui;
}

void RefuseForm::SetOrderInfo(OrderObject *obj)
{
    _Init();
    m_orderObject = obj;
}


void RefuseForm::on_refuseBtnCancle_clicked()
{
    this->reject();
}

void RefuseForm::on_refuseBtnOk_clicked()
{
    this->accept();
}

void RefuseForm::on_reason1_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("门店已打烊");
        m_reasonCode=1;
    }
}

void RefuseForm::on_reason2_toggled(bool checked)
{
    //TODO
    QLOG_INFO() << QString("[<<<<---RefuseForm::on_reason2_toggled: check:%1--->>>>]")<<checked;
    if(m_orderObject!=NULL&&checked)
    {
        m_refDishesForm->InitData(m_orderObject);
        if(QDialog::Accepted == m_refDishesForm->exec())
        {
            ui->refuseBtnOk->setEnabled(true);
            m_reasonStr=QString::fromLocal8Bit("产品已售完");
            m_reasonCode=2;

            QMap<QString,int>::iterator it; //遍历map
            for(it = m_refDishesForm->m_dishesMap.begin(); it != m_refDishesForm->m_dishesMap.end(); ++it) {
                m_refundDishesList.append(it.key());
            }
            m_refundDishesListString = m_refundDishesList.join(";");
            QLOG_INFO() << QString("[<<<<---RefuseForm::on_reason2_toggled: m_refDishesForm->m_dishesMap:%1--->>>>]")<<m_refDishesForm->m_dishesMap;
            QLOG_INFO() << QString("[<<<<---RefuseForm::on_reason2_toggled: m_refundDishesList:%1--->>>>]")<<m_refundDishesList;
            on_refuseBtnOk_clicked();
            QLOG_INFO() << QString("[<<<<---RefuseForm::on_refuseBtnOk_clicked--->>>>]");
        }else{
            _Init();
        }
    }
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("产品已售完");
        m_reasonCode=2;
    }
}

void RefuseForm::on_reason3_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("门店太忙");
        m_reasonCode=3;
    }
}

void RefuseForm::on_reason4_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("联系不上客户");
        m_reasonCode=4;
    }
}

void RefuseForm::on_reason5_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("无人配送");
        m_reasonCode=5;
    }
}

void RefuseForm::_Init()
{
    qDebug() << __FUNCTION__;
    m_refundDishesList.clear();
    m_refundDishesListString.clear();
    ui->reasonNULL->toggle();
    ui->refuseBtnOk->setEnabled(false);
}
