﻿#include "refdishesForm.h"
#include "ui_refdishesForm.h"
#include "Control/flowControl.h"
#include "QsLog.h"

refDishesForm::refDishesForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::refDishesForm)
{
    ui->setupUi(this);
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    this->setModal(true);
    connect(this, &refDishesForm::updDishes, &FlowControl::GetInstance(), &FlowControl::onUpdDishesForRef);
}

refDishesForm::~refDishesForm()
{
    delete ui;
}

void refDishesForm::InitData(OrderObject *obj)
{
    //  清除之前的菜品按钮信息
    _Init();

    int i=0;
    Q_UNUSED(i);
    foreach (dishesObject *product, obj->proList)
    {
        ui->refDishesTable->setColumnWidth(0,300);
        ui->refDishesTable->setColumnWidth(1,165);
        ui->refDishesTable->verticalHeader()->setDefaultSectionSize(60);
        QStringList header;  //QString类型的List容器
        header<<QString::fromLocal8Bit("商品名")<<QString::fromLocal8Bit("商品码");
        ui->refDishesTable->setHorizontalHeaderLabels(header);

        ui->refDishesTable->insertRow(0);
        QWidget *pWdg = new QWidget(ui->refDishesTable);
        QHBoxLayout *hLayout = new QHBoxLayout(pWdg);
        QPushButton * pBtn = new QPushButton(pWdg);
        pBtn->setFixedSize(250, 50);
        pBtn->setObjectName(product->code);
        pBtn->setProperty("code", product->code);
        pBtn->setProperty("name",product->name);
        pBtn->setProperty("qty",product->qty);
        pBtn->setText(product->name);
        pBtn->setCheckable(true);
        pBtn->setStyleSheet("QPushButton{    color: #3d3d3d;      \
                                                                        background-color: rgb(255, 255, 255);       \
                                                                        border: 1px solid #C0C0C0;  \
                                                                        border-radius: 3px;}         \
                                            QPushButton:checked     \
                                            {   \
                                                color: rgb(24, 206, 0);       \
                                                background-color: rgb(255, 255, 255);     \
                                                border-radius: 3px;       \
                                                border: 1px solid rgb(24, 206, 0);  \
                                             }");

        hLayout->addWidget(pBtn,1,Qt::AlignCenter);
        //hLayout->setMargin(0);
        pWdg->setLayout(hLayout);
        connect(pBtn, &QPushButton::toggled, this, &refDishesForm::onDishesBtnToggled);
        ui->refDishesTable->setCellWidget(0, 0, pWdg);   // 商品名按钮
        m_btnList.append(pBtn);

        QTableWidgetItem *item0 = new QTableWidgetItem(product->code);
        //item0->setTextAlignment(Qt::AlignLeft|Qt::AlignTop);
        item0->setTextAlignment(Qt::AlignCenter);
        item0->setFlags(Qt::NoItemFlags);
        item0->setSizeHint(QSize(150,50));
        item0->setCheckState(Qt::Unchecked);
        ui->refDishesTable->setItem(0, 1, item0);
        m_twiList.append(item0);
    }
}

void refDishesForm::_Init()
{
    ui->refDishesBtnOk->setEnabled(false);
    foreach(QPushButton* btn, m_btnList)
    {
        QWidget* parentQWid = btn->parentWidget();
        disconnect(btn, &QPushButton::toggled, this, &refDishesForm::onDishesBtnToggled);
        delete btn;
        parentQWid->deleteLater();
    }
    m_btnList.clear();

    foreach(QTableWidgetItem* twi, m_twiList)
    {
        delete twi;
    }
    m_twiList.clear();

    for(int i=0; i<ui->refDishesTable->rowCount(); i++)
    {
        ui->refDishesTable->removeRow(i);
    }
    ui->refDishesTable->clear();
    ui->refDishesTable->clearContents();
    m_dishesMap.clear();
}

void refDishesForm::on_refDishesBtnOk_clicked()
{
    //别的客户用来更新菜单用的;目前 starbucks No Need;
    //emit updDishes("" ,m_dishesMap);
    QLOG_INFO() << QString("[<<<<---refDishesForm::on_refDishesBtnOk_clicked: accept()--->>>>]");
    accept();
}

void refDishesForm::on_refDishesBtnCancle_clicked()
{
    reject();
}

void refDishesForm::onDishesBtnToggled(bool checked)
{
    QPushButton* btn = (QPushButton*)sender();
    if(checked)
    {
        m_dishesMap.insert(btn->objectName(), 0);
    }else
    {
        m_dishesMap.remove(btn->objectName());
    }
    if(m_dishesMap.count() > 0)
    {
        ui->refDishesBtnOk->setEnabled(true);
    }else
    {
        ui->refDishesBtnOk->setEnabled(false);
    }
}
