﻿#ifndef FLOATFORM_H
#define FLOATFORM_H

#include <QDialog>
#include <QMouseEvent>
#include <QTimer>
#include <QSize>
#include <QPropertyAnimation>
#include <QSound>

namespace Ui {
class FloatForm;
}

class FloatForm : public QDialog
{
    Q_OBJECT

public:
    explicit FloatForm(QWidget *parent = 0);
    ~FloatForm();

protected:
    void mouseMoveEvent(QMouseEvent * event);
    void mousePressEvent(QMouseEvent * event);
    void mouseReleaseEvent(QMouseEvent * event);

private:
    Ui::FloatForm *ui;
    // 记录左键按下去后是否移动过
    bool m_bMouseMove;
    // 记录左键是否按下去
    bool m_bMousePress;
    // 拖动前鼠标坐标
    QPoint m_lastMousePos;
    // 此次拖动一共移动的距离
    QPoint m_absMove;

    // 记录门店营业状态
    bool m_bStoreStatus;

    // 记录正常状态图片的大小
    QSize m_imgNormalSize;
    // 记录提示状态图片的大小
    QSize m_imgRemindSize;
    // 记录门店关店状态图片的大小[和正常状态大小一样，此时主要用表现门店的关店状态:切换了图片]
    QSize m_imgStoreCloseSize;
    // 记录是否正在提示
    bool m_bReminding;
    // 闪烁动画
    QPropertyAnimation m_animation;
    // 记录音频文件
    QString m_remindWav;
    // 声音的间隔
    int m_wavPlayInterval;
    // 置顶定时器
    QTimer m_raiseTimer;
    QTimer m_remindTimer;

    /* 功能:初始化
     * 参数:NULL
     * 返回:NULL
     * */
    void _Init();

private slots:
    /* 功能:闪烁
     * 参数:NULL
     * 返回:NULL
     * */
    void _Blink();
    /* 功能:声音
     * 参数:NULL
     * 返回:NULL
     * */
    void _PlayWav();

signals:
    /* 功能:通知主窗口显示
     * 参数:NULL
     * 返回:NULL
     * */
    void showMainForm();

public slots:
    /* 功能:开启提示
     * 参数:[1]提示类型 0新订单1申请退款
     * 返回:NULL
     * */
    void onStartRemind(int type);
    /* 功能:关闭提示
     * 参数:NULL
     * 返回:NULL
     * */
    void onStopRemind();
    /* 功能:显示窗口
     * 参数:NULL
     * 返回:NULL
     * */
    void onShow();

    /* 功能:锁住窗口:enable(false);
     * 参数:NULL
     * 返回:NULL
     * */
    void onLockFloatForm();

    /* 功能:解锁窗口:enable(true);
     * 参数:NULL
     * 返回:NULL
     * */
    void onUnLockFloatForm();

    /* 功能:变更门店营业状态;
     * 参数:bool [1:true-> 营业; false->关店/打烊]
     * 返回:NULL
     * */
    void onUpdateStoreStatus(bool flag);


};

#endif // FLOATFORM_H
