﻿#include "floatForm.h"
#include "ui_floatForm.h"
#include "windows.h"
#include <QPixmap>
#include "DTools/configManger.h"
#include "preDefine.h"
#include "QsLog.h"
#include <QProcess>
#include <QThread>

extern QThread tcpThread;
extern QThread  workThread;

FloatForm::FloatForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FloatForm)
{
    ui->setupUi(this);

    m_bReminding = false;
    m_bStoreStatus = true; //程序启动后,初始化为开店状态;

    QPixmap imgNormal(":float_normal.png");
    m_imgNormalSize = imgNormal.size();

    QPixmap imgStoreClose(":float_storeCloseStatus.png");
    m_imgStoreCloseSize = imgStoreClose.size();

    QPixmap imgRemind(":float_remind.png");
    m_imgRemindSize = imgRemind.size();

    m_animation.setTargetObject(this);
    m_animation.setPropertyName("windowOpacity");
    m_animation.setDuration(ConfigManger::GetInstance().GetBlinkInterval());
    m_animation.setEasingCurve(QEasingCurve::InOutSine);
    m_raiseTimer.setInterval(2000);
    connect(&m_raiseTimer, &QTimer::timeout, this, &FloatForm::raise);
    _Init();
}

FloatForm::~FloatForm()
{       
    delete ui;
}

void FloatForm::mouseMoveEvent(QMouseEvent *event)
{
    if ((event->buttons()==Qt::LeftButton) && m_bMousePress)
    {
        QPoint moveAmount = event->globalPos() - m_lastMousePos;
        m_absMove += moveAmount;
        move(pos() + moveAmount);
        m_lastMousePos = event->globalPos();
        m_bMouseMove = true;
    }
}

void FloatForm::mousePressEvent(QMouseEvent *event)
{
    if (event->button()==Qt::LeftButton)
    {
        m_bMousePress = true;
        m_lastMousePos = event->globalPos();
        m_absMove = QPoint(0,0);
    }
//    if(event->button()==Qt::RightButton)
//    {

//        sInfoThread.terminate();
//        workThread.terminate();
//        qApp->exit(-1);
//        QProcess::startDetached(qApp->applicationFilePath(), QStringList(qApp->applicationFilePath()));
//    }
}

void FloatForm::mouseReleaseEvent(QMouseEvent *event)
{
    if (event->button()==Qt::LeftButton)
    {
        m_bMousePress = false;
    }
    int x = m_absMove.x();
    int y = m_absMove.y();
    if(!m_bMouseMove || (((x>-10)&&(x<10))&&((y>-10)&&(y<10))))
    {
        hide();
        m_raiseTimer.stop();
        emit showMainForm();
        onStopRemind();
    }

    m_bMouseMove = false;
    QPoint point = this->pos();
    QLOG_INFO()<<QString::fromLocal8Bit("float current Form position(x:%1,y:%2)").arg(point.x()).arg(point.y());
    int nWidth = GetSystemMetrics(SM_CXSCREEN) - 200;
    int nHeight = GetSystemMetrics(SM_CYSCREEN) - 220;
    QLOG_INFO()<<QString::fromLocal8Bit("floatForm active_Range(x:%1,y:%2)").arg(nWidth).arg(nHeight);
    if( (point.x()<nWidth && -80<=point.x() && -50<=point.y()) || (point.y()<nHeight && -80<=point.x() && -50<=point.y()) ){
        ConfigManger::GetInstance().setFloatInitPostion(this->pos());
    }else{
        point.setX(nWidth);
        point.setY(nHeight);
        this->move(QPoint(nWidth, nHeight));
        ConfigManger::GetInstance().setFloatInitPostion(point);
    }
}

void FloatForm::_Init()
{
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint | Qt::Tool);
    setAttribute(Qt::WA_TranslucentBackground);
    //根据门店的开店/关店 状态来显示不同的图片;
    if(m_bStoreStatus) {
        setFixedSize(m_imgNormalSize);
        setStyleSheet("#floatWdg{ border-image: url(:float_normal.png); }");
    }else{
        setFixedSize(m_imgStoreCloseSize);
        setStyleSheet("#floatWdg{ border-image: url(:float_storeCloseStatus.png); }");
    }
    //setFixedSize(m_imgNormalSize);
    //setStyleSheet("#floatWdg{ border-image: url(:float_normal.png); }");
    QPoint point = ConfigManger::GetInstance().GetFloatInitPostion();
    QLOG_INFO()<<QString::fromLocal8Bit("Float From Init Postion(x:%1,y:%2)").arg(point.x()).arg(point.y());
    int nWidth = GetSystemMetrics(SM_CXSCREEN) - 200;
    int nHeight = GetSystemMetrics(SM_CYSCREEN) - 220;
    if( (point.x()<nWidth && -80<=point.x() && -50<=point.y()) || (point.y()<nHeight && -80<=point.x() && -50<=point.y()) ){
        ConfigManger::GetInstance().setFloatInitPostion(point);
        this->move(point);
    }else{
        point.setX(nWidth);
        point.setY(nHeight);
        this->move(QPoint(nWidth, nHeight));
        ConfigManger::GetInstance().setFloatInitPostion(point);
    }
}

void FloatForm::_Blink()
{
    QEventLoop loop;
    connect(&m_animation, &QPropertyAnimation::finished, &loop, &QEventLoop::quit);
    m_animation.setStartValue(1);
    m_animation.setEndValue(0);
    m_animation.start();
    loop.exec();
    this->setFixedSize(m_imgRemindSize);
    ui->floatWdg->setStyleSheet("#floatWdg{ border-image: url(:float_remind.png);}");
    m_animation.setStartValue(0);
    m_animation.setEndValue(1);
    m_animation.start();
    loop.exec();
    m_animation.setStartValue(1);
    m_animation.setEndValue(0);
    m_animation.start();
    loop.exec();

    if(m_bStoreStatus) {
        this->setFixedSize(m_imgNormalSize);
        ui->floatWdg->setStyleSheet("#floatWdg{ border-image: url(:float_normal.png);}");
    }else{
        this->setFixedSize(m_imgStoreCloseSize);
        ui->floatWdg->setStyleSheet("#floatWdg{ border-image: url(:float_storeCloseStatus.png);}");
    }
    m_animation.setStartValue(0);
    m_animation.setEndValue(1);
    m_animation.start();
    loop.exec();

    if(m_bReminding)
    {
        QTimer::singleShot(ConfigManger::GetInstance().GetBlinkInterval(), this, &FloatForm::_Blink);
    }
}

void FloatForm::_PlayWav()
{
    QSound::play(m_remindWav);

    if(m_bReminding)
    {
        QTimer::singleShot(m_wavPlayInterval, this, &FloatForm::_PlayWav);
    }
}

void FloatForm::onStartRemind(int type)
{
    switch(type)
    {
    case REMIND_CONFIRMED_ORDER:
        m_remindWav = QString("%1/wav/msg.wav").arg(QApplication::applicationDirPath());
        // 加上音频的时长
        m_wavPlayInterval = ConfigManger::GetInstance().GetSoundInterval() + VALUE_NEWORDERTIME;
        break;
    case REMIND_REQREFUND_ORDER:
        m_remindWav = QString("%1/wav/msg1.wav").arg(QApplication::applicationDirPath());
        m_wavPlayInterval = ConfigManger::GetInstance().GetSoundInterval() + VALUE_REFUNDORDERTIME;
        break;
    }

    if(m_bReminding)
    {
        return;
    } else {
       m_bReminding = true;
    }
    m_remindTimer.start(1000*30);
    m_remindTimer.setSingleShot(true);
    connect(&m_remindTimer, &QTimer::timeout, this, &FloatForm::onStopRemind);

    _Blink();
    _PlayWav();
}

void FloatForm::onStopRemind()
{
    m_bReminding = false;
}

void FloatForm::onShow()
{
    show();
    m_raiseTimer.start();
}


void FloatForm::onLockFloatForm(){
    QLOG_INFO()<<QString("[<<<----FloatForm::onLockFloatForm : Lock Float Form --->>>>]");
    this->setEnabled(false);
}


void FloatForm::onUnLockFloatForm(){
    QLOG_INFO()<<QString("[<<<----FloatForm::onUnLockFloatForm : unLock Float Form --->>>>]");
    //QThread::sleep(8);
    this->setEnabled(true);
}

void FloatForm::onUpdateStoreStatus(bool flag){
    QLOG_INFO()<<QString("[<<<----FloatForm::onUpdateStoreStatus:flag: --->>>>]")<<flag;
    m_bStoreStatus = flag;
    if(m_bStoreStatus) {
        this->setFixedSize(m_imgNormalSize);
        ui->floatWdg->setStyleSheet("#floatWdg{ border-image: url(:float_normal.png);}");
    }else{
        this->setFixedSize(m_imgStoreCloseSize);
        ui->floatWdg->setStyleSheet("#floatWdg{ border-image: url(:float_storeCloseStatus.png);}");
    }
}
