﻿#include "dishesForm.h"
#include "ui_dishesForm.h"
#include <QPushButton>
#include "Control/flowControl.h"
#include <QDebug>
#include "disTabWdg.h"

dishesForm::dishesForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::dishesForm)
{
    ui->setupUi(this);

    connect(&FlowControl::GetInstance(), &FlowControl::iniDishesData, this, &dishesForm::IniDishesData);

    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    this->setModal(true);
}

dishesForm::~dishesForm()
{
    delete ui;
}

void dishesForm::IniDishesData(QMap<QString, QMultiMap<QString, dishesObject> > dataMap)
{
    // 清除TabWidget中的Tab
    ui->channelTabWdg->clear();
    // 清除TabWidget中的Widget控件
    foreach(QTabWidget *pTabWdg, m_tabWdgList)
    {
        delete pTabWdg;
    }
    m_tabWdgList.clear();

    // 初始化TabWidget
    // 遍历各渠道
    foreach(QString channelCode_Name, dataMap.keys())
    {
        QTabWidget *pChannelTabWidget = new QTabWidget(this);
        ui->channelTabWdg->addTab(pChannelTabWidget, channelCode_Name.split(":").at(0));
        m_tabWdgList.append(pChannelTabWidget);

        //QStringList varietyList;
        QMap<int,  QString> sortMap;
        foreach (QString variety, dataMap.value(channelCode_Name).uniqueKeys()) {
            QString strRank = variety.split(":").at(1);
            //varietyList.append(variety);
            sortMap.insert(strRank.toInt(), variety);
        }

        QStringList varietyList;
        if(sortMap.count()!=0)
        {
            QMap<int,  QString>::iterator iter;
            for(iter = sortMap.begin(); iter!=sortMap.end();iter++)
            {
                varietyList.insert(0, iter.value());
            }
        }


        foreach (QString variety, varietyList) {
           disTabWdg *pTabWdg = new disTabWdg(pChannelTabWidget);
           connect(pTabWdg, &disTabWdg::doHide, this, &dishesForm::hide);
           pTabWdg->IniDishesData(channelCode_Name.split(":").at(1), dataMap.value(channelCode_Name).values(variety));
           QString strVarietyName = variety.split(":").at(0);
           pChannelTabWidget->addTab(pTabWdg, strVarietyName);
        }
    }

    this->show();
}
