﻿#include "bstatusItem.h"
#include "ui_bstatusItem.h"
#include <QStringList>
#include "Control/flowControl.h"

BStatusItem::BStatusItem(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::BStatusItem)
{
    ui->setupUi(this);

    ui->btsItemYY->setEnabled(false);
    ui->btsItemZX->setEnabled(false);
}

BStatusItem::~BStatusItem()
{
    delete ui;
}

void BStatusItem::InitData(QString str)
{
    QStringList list = str.split(":");

    m_channelCode = list.at(0);
    m_channelName = list.at(1);
    m_channelStatus = QString(list.at(2)).toInt();

    ui->btsItemLab->setText(m_channelName);

    if(m_channelStatus == 0)
    {
        // 关店中
        ui->btsItemYY->setEnabled(true);
    }else
    {
        // 营业中
        ui->btsItemZX->setEnabled(true);
    }
}

void BStatusItem::on_btsItemYY_clicked()
{
    emit setStoreOperatingStatus(m_channelCode,m_channelName, 1);
}

void BStatusItem::on_btsItemZX_clicked()
{
    emit setStoreOperatingStatus(m_channelCode,m_channelName, 0);
}

void BStatusItem::onSetStoreOperatingStatusFinsh(int newStatus)
{
    if(newStatus==m_channelStatus){return;}
    int channelStatus=(m_channelStatus==1?0:1);
    if(channelStatus == 0)
    {
        // 关店中
        ui->btsItemYY->setEnabled(true);
        ui->btsItemZX->setEnabled(false);
    }else
    {
        // 营业中
        ui->btsItemYY->setEnabled(false);
        ui->btsItemZX->setEnabled(true);
    }
}
