﻿#include "alertForm.h"
#include "ui_alertForm.h"

AlertForm::AlertForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::AlertForm)
{
    ui->setupUi(this);
    m_timer =new QTimer(this);
    m_timer->setSingleShot(true);
    connect(m_timer,&QTimer::timeout,this,&AlertForm::hideForm);
    _Init();
}

AlertForm::~AlertForm()
{
    delete ui;
}

void AlertForm::SetContent(AlertForm::Type type, const QString &msg)
{
    switch(type)
    {
    case SUCCESS:
        ui->alertBtnOk->show();
        ui->alertLabOk->show();
        ui->alertLabIng->hide();
        ui->alertLabError->hide();
        break;
    case MSGERROR:
        ui->alertBtnOk->show();
        ui->alertLabOk->hide();
        ui->alertLabIng->hide();
        ui->alertLabError->show();
        break;
    case LOADING:
        ui->alertBtnOk->hide();
        ui->alertLabOk->hide();
        ui->alertLabIng->show();
        ui->alertLabError->hide();
        break;
    }
    ui->alertLabMsg->setText(msg);
    if(!m_timer->isActive())
        m_timer->start(20000);
    return;
}

void AlertForm::_Init()
{
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    this->setModal(true);

    // 初始化Gif动画
    m_movie = new QMovie(this);
    m_movie->setFileName(":loading.gif");
    ui->alertLabIng->setMovie(m_movie);
    ui->alertLabIng->setScaledContents(true);
    m_movie->start();

    ui->alertLabOk->hide();
    ui->alertLabIng->hide();
    ui->alertLabError->hide();
}

void AlertForm::hideForm()
{
    this->hide();
}

void AlertForm::on_alertBtnOk_clicked()
{
    this->hide();
    return;
}
