#include "getCaboxAReAuth.h"
#include "QsLog.h"
#include <QDateTime>
#include "Control/flowControl.h"
#include "preDefine.h"

GetCaboxAReAuth::GetCaboxAReAuth() {
    QLOG_INFO()<<"[<<<<---GetCaboxAReAuth:: Structure POS Get Has Cash Box Or Refund Auth DataBase--->>>>]";
}

bool GetCaboxAReAuth::initGetAuthPosDB(){
    m_sqlDb = QSqlDatabase::addDatabase("QODBC","GetCaboxAReAuth");   //数据库驱动类型为SQL Server
    if(m_sqlDb.isValid()){
        QLOG_INFO()<<"[<<<<---SqlServer ODBC driver is valid--->>>>]";
        QString dsn="DRIVER={SQL SERVER};SERVER=127.0.0.1\\sqlexpress;DATABASE=DataStore";
        m_sqlDb.setDatabaseName(dsn);                            //设置数据源名称
        m_sqlDb.setUserName("sa");                               //登录用户
        m_sqlDb.setPassword("SIM29@123");

        if(!m_sqlDb.open()) {                                      //打开数据库
            QLOG_ERROR()<<"[<<<<---SqlServer Open Database error:--->>>>]"<<m_sqlDb.lastError().text();
        } else {
            QLOG_INFO()<<"[<<<<---SqlServer Test Open database success!:--->>>>]";
            m_sqlDb.close();
            return true;
        }
    } else {
        QLOG_ERROR()<<"[<<<<---SqlServer ODBC driver no valid--->>>>]";
    }
    return false;
}

GetCaboxAReAuth &GetCaboxAReAuth::getInstance()
{
    static GetCaboxAReAuth GetCaboxAReAuth;
    return GetCaboxAReAuth;
}

int GetCaboxAReAuth::getUserHasCashBox(const QString& operatorId){
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return 0;
    }
    int result=0;
    QSqlQuery query(m_sqlDb);
    QLOG_INFO()<<QString("select count(*) from [DataStore].[dbo].employee as A, [DataStore].[dbo].CM_EMPLOYEE_TILL_ASSIGNMENT as B where A.EmployeeID = B.EmployeeID and ObjectNumber='%1'").arg(operatorId);
    query.prepare(QString("select count(*) from [DataStore].[dbo].employee as A, [DataStore].[dbo].CM_EMPLOYEE_TILL_ASSIGNMENT as B where A.EmployeeID = B.EmployeeID and ObjectNumber='%1'").arg(operatorId));
    if(!query.exec()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:getUserHasCashBox--->>>>]"<<query.lastError().text();
        result= 0;
    }
    if(query.first()) {
        result= query.value(0).toInt()?1:0;
        QLOG_INFO()<<"[<<<<---SqlServer Database operatorId:%1,getUserHasCashBox:%2--->>>>]"<<operatorId<<result;
    } else {
        result = 0;
    }
    m_sqlDb.close();
    return result;
}

int GetCaboxAReAuth::getUserRefundAuth(const QString& operatorId){
    QMutexLocker mutex(&m_mutex);
    Q_UNUSED(operatorId)
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return 0;
    }
    int result = 0;
    QSqlQuery query(m_sqlDb);
    QLOG_INFO()<<QString("SELECT count(*) FROM [DataStore].[dbo].[EMPLOYEE] AS A , [DataStore].[dbo].[ROLE_EMPLOYEE] AS B WHERE A.EmployeeID = B.EmployeeID  and B.RoleID in (2,10)  AND ObjectNumber ='%1'").arg(operatorId);
    query.prepare(QString("SELECT count(*) FROM [DataStore].[dbo].[EMPLOYEE] AS A , [DataStore].[dbo].[ROLE_EMPLOYEE] AS B WHERE A.EmployeeID = B.EmployeeID  and B.RoleID in (2,10)  AND ObjectNumber ='%1'").arg(operatorId));
    if(!query.exec()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:getUserRefundAuth--->>>>]"<<query.lastError().text();
        result= 0;
    }
    if(query.first()) {
        result= query.value(0).toInt()?1:0;
        QLOG_INFO()<<"[<<<<---SqlServer Database operatorId:%1,getUserRefundAuth:%2--->>>>]"<<operatorId<<result;
    } else {
        result = 0;
    }
    m_sqlDb.close();
    return result;
}

