﻿#ifndef CLICKEDLINEEDIT_H
#define CLICKEDLINEEDIT_H

#include <QMouseEvent>
#include <QLineEdit>

class ClickedLineEdit : public QLineEdit
{
    Q_OBJECT
public:
    ClickedLineEdit(QWidget *parent = 0)
        :QLineEdit(parent){}

protected:
    void mousePressEvent(QMouseEvent *event)
    {
        if (event->button()==Qt::LeftButton)//拦截点击左键动作
        {
            emit clicked();
            event->accept();//默认处理过程
        }
    }

signals:
    void clicked();
};

#endif // CLICKEDLINEEDIT_H
