﻿#ifndef REFUSEFORM_H
#define REFUSEFORM_H

#include <QDialog>
#include <QMap>
#include <QRadioButton>
#include <Model/orderObject.h>
#include "refdishesForm.h"

namespace Ui {
class RefuseForm;
}

class RefuseForm : public QDialog
{
    Q_OBJECT

public:
    explicit RefuseForm(QWidget *parent = 0);
    ~RefuseForm();

    QString m_reasonStr;

    int m_reasonCode;

    QStringList m_refundDishesList;

    QString m_refundDishesListString;

    void SetOrderInfo(OrderObject*);

private slots:
    /* 功能:取消按钮对应的操作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_refuseBtnCancle_clicked();
    /* 功能:确定按钮对应的操作
     * 参数:[bEnable]是否启用
     * 返回:NULL
     * */
    void on_refuseBtnOk_clicked();

    void on_reason1_toggled(bool checked);

    void on_reason2_toggled(bool checked);

    void on_reason3_toggled(bool checked);

    void on_reason4_toggled(bool checked);

    void on_reason5_toggled(bool checked);

    void on_reason6_toggled(bool checked);

    void on_reason7_toggled(bool checked);

public slots:
     void clearAllRadioBtnCheck();

     void hideSelectProductFrom();

private:
    Ui::RefuseForm *ui;

    OrderObject* m_orderObject;

    refDishesForm* m_refDishesForm;

    void _Init();

//    QString m_orderId;
//    QString m_operation;
};

#endif // REFUSEFORM_H
