﻿#include "disTabWdg.h"
#include "ui_disTabWdg.h"
#include "Control/flowControl.h"
#include <QScrollBar>

disTabWdg::disTabWdg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::disTabWdg)
{
    ui->setupUi(this);

    connect(this, &disTabWdg::doUpdDishes, &FlowControl::GetInstance(), &FlowControl::onUpdDishes);
}

disTabWdg::~disTabWdg()
{
    delete ui;
}

void disTabWdg::IniDishesData(QString channelCode, QList<dishesObject> disObjList)
{

    m_disObjList.clear();
    m_channelCode = channelCode;

    QMap<int,  dishesObject> sortMap;
    foreach (dishesObject obj, disObjList)
    {
        //sortMap.insert(obj.rank, obj);
    }

    QMap<int,  dishesObject>::iterator iter;
      for(iter = sortMap.begin(); iter!=sortMap.end();iter++)
      {
          m_disObjList.insert(0, iter.value());
      }

    int index = 0;
    int row = 0;
    foreach(dishesObject dObj, m_disObjList)
        //foreach(dishesObject dObj, disObjList)
    {
        //dishesItem *item = new dishesItem(m_channelCode, dObj.code, dObj.status, dObj.name,this);

        if(index==0)
        {
            row = ui->disTabWdg_tablewdg->rowCount();
            ui->disTabWdg_tablewdg->insertRow(row);
        }
        //ui->disTabWdg_tablewdg->setCellWidget(row, index, item);
        index++;
        if(index==2)
        {
            index=0;
        }
    }
}

void disTabWdg::on_disTabWdg_close_clicked()
{
    emit doHide();
}

void disTabWdg::on_disTabWdg_btnup_clicked()
{
    ui->disTabWdg_tablewdg->verticalScrollBar()->setValue(ui->disTabWdg_tablewdg->verticalScrollBar()->value()-15);
}

void disTabWdg::on_disTabWdg_btndown_clicked()
{
    ui->disTabWdg_tablewdg->verticalScrollBar()->setValue(ui->disTabWdg_tablewdg->verticalScrollBar()->value()+15);
}

void disTabWdg::on_disTabWdg_btnsj_clicked()
{
    QMap<QString, int> map;
    foreach(dishesObject obj, m_disObjList)
    {
        map.insert(obj.code, 1);
    }

    emit doUpdDishes(m_channelCode, map);
}

void disTabWdg::on_disTabWdg_btnxj_clicked()
{
    QMap<QString, int> map;
    foreach(dishesObject obj, m_disObjList)
    {
        map.insert(obj.code, 0);
    }

    emit doUpdDishes(m_channelCode, map);
}
