﻿#ifndef DETAILFORM_H
#define DETAILFORM_H

#include <QDialog>
#include <QTableWidget>
#include "Model/orderObject.h"
#include "Model/deliverObject.h"
#include "RejectForm.h"
#include "refuseForm.h"

namespace Ui {
class DetailForm;
}

class DetailForm : public QDialog
{
    Q_OBJECT

public:
    explicit DetailForm(QWidget *parent = 0);
    ~DetailForm();

    /* 功能:初始化数据
     * 参数:[1]订单对象
     * 返回:NULL
     * */
    void InitData(OrderObject* orderObject);

private:
    Ui::DetailForm *ui;

    OrderObject *m_orderObject;

    /* 功能:初始化
     * 参数:NULL
     * 返回:NULL
     * */
    void _Init();
    RejectForm *m_rejectForm;
    RefuseForm *m_refuseForm;
    QString GetProductName(dishesObject* dish);

signals:
    /* 功能:处理订单
     * 参数:[1]操作动作名[2]订单编号[3]配送员信息
     * 返回:NULL
     * */
    void processOrder(const QString& operation, const QString& orderId);
    void processRejectOrder(const QString& orderId,const int& reasonCode,const QString& reason);

    /* 功能:作废订单
     * 参数:[1]订单编号 [2]作废原因码 [3]作废原因 [4]商品列表
     * 返回:NULL
     * */
    void processRepealOrder(const QString& orderId,const int& reasonCode,const QString& reason,const QString& dishesList);

    /* 功能:重新尝试录入订单
     * 参数:[1]订单编号
     * 返回:NULL
     * */
    void processRetryInputOrder(const QString& orderId);

private slots:
    /* 功能:处理订单按钮点击
     * 参数:NULL
     * 返回:NULL
     * */
    void onOperaBtnClicked();


    /* 功能:处理重新打印按钮点击
     * 参数:NULL
     * 返回:NULL
     * */
    void on_detailBtn1_clicked();


    /* 功能:处理点击 重新录单按钮
     * 参数:NULL
     * 返回:NULL
     * */
    void on_detailBtn0_clicked();

public slots:
    /* 功能:退单和录单同时进行时，优先录单，在 mainFrom 最小化时，会调用 DetailForm 最小化，其内部的子对象需要释放，否则会引发程序崩溃退出;
     * 参数:NULL
     * 返回:NULL
     * */
    void hideDetailAllFrom();

};

#endif // DETAILFORM_H
