﻿#ifndef DAYREPORTFORM_H
#define DAYREPORTFORM_H

#include <QDialog>
#include <QJsonObject>

namespace Ui {
class DailyReportForm;
}

class DailyReportForm : public QDialog
{
    Q_OBJECT

public:
    explicit DailyReportForm(QWidget *parent = 0);
    ~DailyReportForm();
    /**
    *功能:背景半透明，控件不透明
    *参数:NULL
    *返回:NULL
    **/
    void paintEvent(QPaintEvent *event);

private slots:
    /**
    *功能:隐藏界面
    *参数:NULL
    *返回:NULL
    **/
    void on_btn_close_clicked();

private:
    Ui::DailyReportForm *ui;
    double salesOrdersNumTotal,salesOrdersSumTotal;
    double refundsOrdersNumTotal,refundsOrdersSumTotal;
    double entrySuccessNum,entrySuccessSum;
    double entryFailedNum,entryFailedSum;
    void CountFee(double& salesOrdersNum, double& salesOrdersSumELM,
                  double& refundsOrdersNum, double& refundsOrdersSum, const QJsonObject &json);
    /**
    *功能:初始化
    *参数:NULL
    *返回:NULL
    **/
    void _Init();
    /**
    *功能:设置个平台数据
    *参数:[1]日结数据
    *返回:NULL
    **/
    void _SetChannelData(QJsonObject json);

public slots:
    /**
    *功能:添加数据
    *参数:[1]日结数据
    *返回:NULL
    **/
    void Initdata(QJsonObject json);
};

#endif // DAYREPORTFORM_H
