﻿#ifndef CERTIFICATE_OPERATE
#define CERTIFICATE_OPERATE

#include <string>
#include <QFile>
#include <QString>
#include <QJsonObject>
#include <QJsonDocument>
#include "QsLog.h"
#include "MacTool.h"
#include "AlgorithmProcess.h"

/*
 下载证书时:  将请求 json 组合拼装好, 额外对 Mac 地址加密后, 添加到 json中, 进行证书 的下载【Svr的公钥 + Client的私钥】

 业务数据交互:  将请求 json 组合拼装好, 额外对 Mac 地址, 添加到 json中, 对登录请求报文【使用 Client的私钥 进行加签】
 */

class CertificateOperate
{
public:

    static QString uncharToQstring(unsigned char * id, int len)
    {
        QString msg;
        int j = 0;

        while (j<len) {
            if ( '\0'  == id[j] ) {   // 字节数组出现 '\0'  就及时截断;
                return msg;
            } else {
                // temp = QString("%1").arg((int)id[j], 2, 16, QLatin1Char('0'));
                msg.append( id[j] );
                j++;
            }
        }

        return msg;
    }


    static bool GetSecrtKeyAESDecode( const QString &aesSecretKey, const QString &aesSecretKeyIv, const QString &encryptKey, QString &decryptKey ) {

        // 存储解密结果;
        unsigned char tmpOutByte[MAX_BUF_LEN] = { 0 };

        // 将 Secret Key 由 QString ->  char * ;
        char tmpSecretKey[100] = {0};
        memcpy(tmpSecretKey, aesSecretKey.toUtf8().data(), aesSecretKey.toUtf8().size() > 24 ? 24 : aesSecretKey.toUtf8().size());

        // 将 Secret Key Ivp 由 QString -> char * ;
        char tmpiv[17] = {0};
        memcpy(tmpiv, aesSecretKeyIv.toUtf8().data(), aesSecretKeyIv.toUtf8().size() > 16 ? 16 : aesSecretKeyIv.toUtf8().size());

        // 将未解密的密文 由 QString -> char * ;
        char *buf = (char *)calloc(encryptKey.toUtf8().size() + 100, sizeof(char));
        strcpy(buf, encryptKey.toUtf8().data() );

        if(AlgorithmProcess::AESDecode( (unsigned char *)tmpSecretKey, (unsigned char *)tmpiv, (const unsigned char *)buf, strlen(buf), tmpOutByte, MAX_BUF_LEN) == 0)
        {
            QLOG_ERROR() << "GetSecrtKeyAESDecode:: AESDecode Failed";
            free(buf);  // 释放临时申请堆内存;
            return false;
        }

        free(buf); // 释放临时申请堆内存;
        QLOG_INFO()<< " GetSecrtKeyAESDecode:: AESDecode Success : " << tmpOutByte << "  tmpOutByte Length: "<< strlen( (char*)tmpOutByte );
        decryptKey = uncharToQstring( tmpOutByte, sizeof(tmpOutByte) );
        return true;
    }


    static bool GetCertifiSign( QJsonObject &json, const QString &iv, const QString &publishKey, const QString &privateKey, QJsonObject &outRealReqJson )
    {
        Q_UNUSED(iv);
        Q_UNUSED( publishKey );

        QStringList list;
        QString values;
        AlgorithmProcess::GetKeyListFromJson(list, json);
        AlgorithmProcess::SortString(list);
        AlgorithmProcess::GetKeyValueListFromJson(list, json, values);
        QLOG_INFO() << "GetCertifiSign Before,   privateKey: " << privateKey << "  KeyValueList: "<< values;

        char tmpOutSignByte[MAX_SIGN_LEN] = { 0 };
        // QString 转化成unsigned char *
        char tmpPrivateKey[MAX_AES_KEY_LEN] = {0};
        memcpy(tmpPrivateKey, privateKey.toUtf8().data(), privateKey.toUtf8().size() );

        char tmpArray[MAX_BUF_LEN] = {0};
        memcpy(tmpArray, values.toUtf8().data(), values.toUtf8().size() );

        QLOG_INFO() << "GetCertifiSign Start RSA_SHA1 & Out Base64  bit-128(Real: 172) ......";

        // RSA 加密方式;
        // 根据加密要求:  使用SHA1WithRSA算法签名 ,  结果用Base64编码输出 128 长度;
        if( AlgorithmProcess::RSASignWithSHA1( tmpArray, tmpOutSignByte, MAX_SIGN_LEN,  tmpPrivateKey ) == 0 ) {
            QLOG_ERROR() << "Get RSASignWithSHA1  Failed";
            return false;
        }

        QString sign = tmpOutSignByte;
        QLOG_INFO() << "Get RSASignWithSHA1 Success Sign: " << sign;
        outRealReqJson.insert(JSON_TCP_INFO, json);
        outRealReqJson.insert(JSON_TCP_SIGN, sign);
        return true;
    }

};

#endif // CERTIFICATE_OPERATE
