#ifndef MACTOOL
#define MACTOOL

/*
#include <WinSock2.h>
#include <iphlpapi.h>
#include <IPTypes.h>
#include <Windows.h>
#include <string>
*/
#include "QsLog.h"
#include <QNetworkInterface>
#include <QString>

class MacTool
{
public:

    static int GetMacByAdaptersAddresses(std::string& macOut)
    {
        int ret = 0;
        /*
        ULONG outBufLen = sizeof(IP_ADAPTER_ADDRESSES);
        PIP_ADAPTER_ADDRESSES pAddresses = (IP_ADAPTER_ADDRESSES*)malloc(outBufLen);
        if (pAddresses == NULL)
            return 0;

        // Make an initial call to GetAdaptersAddresses to get the necessary size into the ulOutBufLen variable
        if(GetAdaptersAddresses(AF_UNSPEC, 0, NULL, pAddresses, &outBufLen) == ERROR_BUFFER_OVERFLOW)
        {
            free(pAddresses);
            pAddresses = (IP_ADAPTER_ADDRESSES*)malloc(outBufLen);
            if (pAddresses == NULL)
                return 0;
        }

        if(GetAdaptersAddresses(AF_UNSPEC, 0, NULL, pAddresses, &outBufLen) == NO_ERROR)
        {
            for(PIP_ADAPTER_ADDRESSES pCurrAddresses = pAddresses; pCurrAddresses != NULL; pCurrAddresses = pCurrAddresses->Next)
            {
                if(pCurrAddresses->PhysicalAddressLength != 6)
                    continue;
                char acMAC[32];
                sprintf(acMAC, "%02X-%02X-%02X-%02X-%02X-%02X",
                    int (pCurrAddresses->PhysicalAddress[0]),
                    int (pCurrAddresses->PhysicalAddress[1]),
                    int (pCurrAddresses->PhysicalAddress[2]),
                    int (pCurrAddresses->PhysicalAddress[3]),
                    int (pCurrAddresses->PhysicalAddress[4]),
                    int (pCurrAddresses->PhysicalAddress[5]));
                macOut = acMAC;
                ret = 1;
                break;
            }
        }

        free(pAddresses);
        return ret;
        */

        QString address ="";
        auto interfaces = QNetworkInterface::allInterfaces();
        for (int i = 0; i < interfaces.length(); i++) {
            QLOG_INFO()<<QString("GetMacByAdaptersAddresses:: interfaces[ %1 ] = %2 ").arg( i+1 ).arg( interfaces[i].hardwareAddress() );
            if ( interfaces[i].isValid() ) {
                /* if( interfaces[i].flags().testFlag(QNetworkInterface::IsUp) &&
                    interfaces[i].flags().testFlag(QNetworkInterface::IsRunning) &&
                    !interfaces[i].flags().testFlag(QNetworkInterface::IsLoopBack)) */
                address = interfaces[i].hardwareAddress();
                break;
            }
        }

        if (address.isEmpty()) {
            QLOG_ERROR()<<QString("GetMacByAdaptersAddresses:: Local Hardware Address Acquisition Failed!");
        } else {
            ret = 1;
            address = address.replace(QRegExp(":"), "-");
            macOut = address.toStdString();
            QLOG_INFO()<<QString("GetMacByAdaptersAddresses::MAC= %1 ").arg( address );
        }
        return ret;
    }

};

#endif // MACTOOL

