﻿#ifndef SINGLEPRODUCTOBJECT_H
#define SINGLEPRODUCTOBJECT_H

#include <QObject>
#include <QJsonObject>
#include <QVariant>
#include <QMetaProperty>

class SingleProductObject : public QObject
{
    Q_OBJECT
    Q_PROPERTY (QString code READ getCode WRITE setCode)
    Q_PROPERTY (QString name READ getName WRITE setName)
    Q_PROPERTY (int qty READ getQty WRITE setQty)
    Q_PROPERTY (int price READ getPrice WRITE setPrice)
    Q_PROPERTY (bool isCoupon READ getIsCoupon WRITE setIsCoupon)
    Q_PROPERTY (QString nickname READ getNickname WRITE setNickname)

public:
    explicit SingleProductObject(QObject *parent = 0):QObject(parent){}
    SingleProductObject(const SingleProductObject& singleProduct,QObject* parent=0);
    SingleProductObject& operator =(const SingleProductObject& singleProduct);
    void FetchDataFromJson(const QJsonObject &json);
    QString code  = "";
    QString name  = "";
    int qty = 0;
    int price = 0;
    bool isCoupon = false; //此单品是否是券;
    QString nickname ="";         //券商品昵称

protected:
    inline QString getCode(){ return code; }
    inline void setCode(const QString& v){ code = v; }

    inline QString getName(){ return name; }
    inline void setName(const QString& v){ name = v; }

    inline int getQty(){ return qty; }
    inline void setQty(const int& v){ qty = v; }

    inline int getPrice(){ return price; }
    inline void setPrice(const int& v){ price = v; }

    inline bool getIsCoupon(){ return isCoupon; }
    inline void setIsCoupon(const bool& v){ isCoupon = v; }

    inline QString getNickname(){ return nickname; }
    inline void setNickname(const QString& v){ nickname = v; }

};

#endif // SINGLEPRODUCTOBJECT_H
