#include "paymentObject.h"

#include "preDefine.h"
#include <QJsonArray>

PaymentObject::PaymentObject(const PaymentObject &payments, QObject *parent):QObject(parent)
{
    const QMetaObject *m = payments.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++) {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = payments.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
}

PaymentObject& PaymentObject::operator =(const PaymentObject& payments)
{
    const QMetaObject *m = payments.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++) {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = payments.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    return *this;
}

void PaymentObject::FetchDataFromJson(const QJsonObject &json)
{
    foreach(QString key,  json.keys()) {
        setProperty(key.toUtf8(), json[key].toVariant());
    }
    return;
}
