﻿#ifndef ORDEROBJECT_H
#define ORDEROBJECT_H

#include "Model/baseObject.h"
#include "Model/dishesObject.h"
#include "Model/couponsObject.h"
#include "Model/paymentObject.h"
#include <QDateTime>

class OrderObject : public QObject
{
    Q_OBJECT

    Q_PROPERTY (QString id READ getId WRITE setId)
    Q_PROPERTY (QString payfmId READ getPayfmId WRITE setPayfmId)
    Q_PROPERTY (QString thirdPartyBatch READ getThirdPartyBatch WRITE setThirdPartyBatch)
    Q_PROPERTY (QString refundFmId READ getRefundFmId WRITE setRefundFmId)
    Q_PROPERTY (QString thirdPartyOrderId READ getThirdPartyOrderId WRITE setThirdPartyOrderId)

    Q_PROPERTY (int orderType READ getOrderType WRITE setOrderType)
    Q_PROPERTY (QString orgOrderId READ getOrgOrderId WRITE setOrgOrderId)
    Q_PROPERTY (QString waybillId READ getWaybillId WRITE setWaybillId)
    Q_PROPERTY (QString watercourseId READ getWatercourseId WRITE setWatercourseId)
    Q_PROPERTY (QString pickupCode READ getPickupCode WRITE setPickupCode)
    Q_PROPERTY (QString customerId READ getCustomerId WRITE setCustomerId)
    Q_PROPERTY (QString customerName READ getCustomerName WRITE setCustomerName)
    Q_PROPERTY (QString phone READ getPhone WRITE setPhone)

    Q_PROPERTY (QString msr_no READ getMsr_no WRITE setMsr_no)
    Q_PROPERTY (QString storeId READ getStoreId WRITE setStoreId)
    Q_PROPERTY (QString storeName READ getStoreName WRITE setStoreName)
    Q_PROPERTY (QString storeAddress READ getStoreAddress WRITE setStoreAddress)
    Q_PROPERTY (QString channel READ getChannel WRITE setChannel)
    Q_PROPERTY (int payWay READ getPayWay WRITE setPayWay)
    Q_PROPERTY (QString deliveryTime READ getDeliveryTime WRITE setDeliveryTime)
    Q_PROPERTY (QString riderName READ getRiderName WRITE setRiderName)
    Q_PROPERTY (QString riderPhone READ getRiderPhone WRITE setRiderPhone)
    Q_PROPERTY (QString createTime READ getCreateTime WRITE setCreateTime)
    Q_PROPERTY (QString confirmTime READ getConfirmTime WRITE setConfirmTime)
    Q_PROPERTY (QString acceptedDate READ getAcceptedDate WRITE setAcceptedDate)
    Q_PROPERTY (QString sendTime READ getSendTime WRITE setSendTime)
    Q_PROPERTY (QString finishTime READ getFinishTime WRITE setFinishTime)
    Q_PROPERTY (QString cancelTime READ getCancelTime WRITE setCancelTime)
    Q_PROPERTY (QString cancelReason READ getCancelReason WRITE setCancelReason)
    Q_PROPERTY (QString lang READ getLang WRITE setLang)

    Q_PROPERTY (QString memo READ getMemo WRITE setMemo)
    Q_PROPERTY (QString consumerRemark READ getConsumerRemark WRITE setConsumerRemark)
    Q_PROPERTY (QString invoiceType READ getInvoiceType WRITE setInvoiceType)
    Q_PROPERTY (QString invoiceUrl READ getInvoiceUrl WRITE setInvoiceUrl)
    Q_PROPERTY (QString invoiceTitle READ getInvoiceTitle WRITE setInvoiceTitle)
    Q_PROPERTY (QString invoiceTaxpayerId READ getInvoiceTaxpayerId WRITE setInvoiceTaxpayerId)
    Q_PROPERTY (QString firstName READ getFirstName WRITE setFirstName)
    Q_PROPERTY (QString lastName READ getLastName WRITE setLastName)
    Q_PROPERTY (QString longitude READ getLongitude WRITE setLongitude)
    Q_PROPERTY (QString latitude READ getLatitude WRITE setLatitude)
    Q_PROPERTY (QString street READ getStreet WRITE setStreet)
    Q_PROPERTY (QString consigneeName READ getConsigneeName WRITE setConsigneeName)
    Q_PROPERTY (QString consigneePhone READ getConsigneePhone WRITE setConsigneePhone)
    Q_PROPERTY (QString addressDetail READ getAddressDetail WRITE setAddressDetail)
    Q_PROPERTY (QString posCheckNo READ getPosCheckNo WRITE setPosCheckNo)
    Q_PROPERTY (int updateTime READ getUpdateTime WRITE setUpdateTime)
    Q_PROPERTY (int needInvoice READ getNeedInvoice WRITE setNeedInvoice)
    Q_PROPERTY (int deliveryPrice READ getDeliveryPrice WRITE setDeliveryPrice)
    Q_PROPERTY (int deliveryDiscount READ getDeliveryDiscount WRITE setDeliveryDiscount)
    Q_PROPERTY (int disPlateformFee READ getDisPlateformFee WRITE setDisPlateformFee)
    Q_PROPERTY (int packageFee READ getPackageFee WRITE setPackageFee)
    Q_PROPERTY (int isPackage READ getIsPackage WRITE setIsPackage)

    Q_PROPERTY (QString packageSku READ getPackageSku WRITE setPackageSku)
    Q_PROPERTY (QString storeMakeSku READ getStoreMakeSku WRITE setStoreMakeSku)
    Q_PROPERTY (QString secretSignal READ getSecretSignal WRITE setSecretSignal)
    Q_PROPERTY (int packDiscount READ getPackDiscount WRITE setPackDiscount)
    Q_PROPERTY (int orderDiscount READ getOrderDiscount WRITE setOrderDiscount)
    Q_PROPERTY (int estimation READ getEstimation WRITE setEstimation)
    Q_PROPERTY (int appointmentDayFlag READ getAppointmentDayFlag WRITE setAppointmentDayFlag)
    Q_PROPERTY (int productPrice READ getProductPrice WRITE setProductPrice)
    Q_PROPERTY (int totalPrice READ getTotalPrice WRITE setTotalPrice)
    Q_PROPERTY (int orderStatus READ getOrderStatus WRITE setOrderStatus)
    Q_PROPERTY (QString makeStatus READ getMakeStatus WRITE setMakeStatus)
    Q_PROPERTY (QString makeSource READ getMakeSource WRITE setMakeSource)
    Q_PROPERTY (QString makeDeviceId READ getMakeDeviceId WRITE setMakeDeviceId)
    Q_PROPERTY (QString businessType READ getBusinessType WRITE setBusinessType)
    Q_PROPERTY (int forwardPosStatus READ getForwardPosStatus WRITE setForwardPosStatus)
    Q_PROPERTY (int negativePosStatus READ getNegativePosStatus WRITE setNegativePosStatus)
    Q_PROPERTY (int deliveryStatus READ getDeliveryStatus WRITE setDeliveryStatus)
    Q_PROPERTY (int payStatus READ getPayStatus WRITE setPayStatus)
    Q_PROPERTY (int refundStatus READ getRefundStatus WRITE setRefundStatus)
    Q_PROPERTY (int deliveryChannel READ getDeliveryChannel WRITE setDeliveryChannel)
    Q_PROPERTY (QString customerSex READ getCustomerSex WRITE setCustomerSex)
    Q_PROPERTY (QString platformSource READ getPlatformSource WRITE setPlatformSource)
    Q_PROPERTY (int orderIndex READ getOrderIndex WRITE setOrderIndex)

    Q_PROPERTY (QString expectDate READ getExpectDate WRITE setExpectDate)
    Q_PROPERTY (QString reserveMakeTime READ getReserveMakeTime WRITE setReserveMakeTime)
    Q_PROPERTY (int inAdvanceTakemeal READ getInAdvanceTakemeal WRITE setInAdvanceTakemeal)
    Q_PROPERTY (QString subStoreId READ getSubStoreId WRITE setSubStoreId)
    Q_PROPERTY (int globalServiceType READ getGlobalServiceType WRITE setGlobalServiceType)
    Q_PROPERTY (int globalOrderType READ getGlobalOrderType WRITE setGlobalOrderType)

    Q_PROPERTY (int isGiftitForward READ getIsGiftitForward WRITE setIsGiftitForward )

    Q_PROPERTY (QString remindTicketTime READ getRemindTicketTime WRITE setRemindTicketTime )
    Q_PROPERTY (QString carNumber READ getCarNumber WRITE setCarNumber)
    Q_PROPERTY (QString privacyPhone READ getPrivacyPhone WRITE setPrivacyPhone)
    Q_PROPERTY (QString callBackUrl READ getCallBackUrl WRITE setCallBackUrl)
    Q_PROPERTY (QString pcsCallbackUrl READ getPcsCallbackUrl WRITE setPcsCallbackUrl)

    Q_PROPERTY (int extendType READ getExtendType WRITE setExtendType)
    Q_PROPERTY (int deliveryProvider READ getDeliveryProvider WRITE setDeliveryProvider)
    Q_PROPERTY (int deliveryType READ getDeliveryType WRITE setDeliveryType)
    Q_PROPERTY (bool skipPrint READ getSkipPrint WRITE setSkipPrint)

    Q_PROPERTY (bool deliveryAtProd READ getDeliveryAtProd WRITE setDeliveryAtProd)
    Q_PROPERTY (bool packageFeeAtProduct READ getPackageFeeAtProduct WRITE setPackageFeeAtProduct)

public:
    OrderObject(QObject *parent=0)
        :QObject(parent){}
    OrderObject(const OrderObject& order,QObject* parent);
    OrderObject& operator =(const OrderObject& order);

    typedef enum {
        NewOrder=2,Confirmed,Sendout,Finished,Refunded,RequestRefund
        ,Locked=-1,AgreeRefund=30,RefuseRefund=40 ,SimExceptSale=50,SimExceptRefund=51
        /*,Refunded=6  Cancled=6(订单状态是6时，是退单); 退单目前本佳那边不区分*/
    }OrderStatus;

    /* 功能:从Json对象初获取数据
     * 参数:[1]JSon对象
     * 返回:NULL
     * */
    void FromJson(const QJsonObject &json);
    void FetchDataFromJson(const QJsonObject& json);
    QList<dishesObject*>proList;
    //扩展 星巴克 预约实物的券信息 List;
    QList<CouponsObject*>coupList;
    //扩展 星巴克 多条支付方式入机 List;
    QList<PaymentObject*>paymentList;

public:

    QString id ="";  //编号
    QString payfmId = "";  //FM唯一码
    QString thirdPartyBatch = "";  //第三方交易流水号
    QString refundFmId = "";      //退货时，不应该传递第三方交易流水号[应该使用退货的非码ID]
    QString thirdPartyOrderId = ""; //第三方订单ID
    int orderType = 0; //订单类型: 用来区分是 正常订单(1) 预订单(2) 还是 客诉单:3 (星巴克定义客诉单的类型:12);
    QString orgOrderId  = ""; //原始订单编号
    QString waybillId = "";  //运单号
    QString watercourseId = ""; //流水号
    QString pickupCode = ""; //取餐号
    QString customerId = ""; //用户编号
    QString customerName = "";//用户名称
    QString posCheckNo = ""; // POS小票号
    QString phone = "";
    QString msr_no = "";  //msr卡号
    QString storeId = "";
    QString storeName = "";
    QString storeAddress = "";
    QString channel = "";   //订单渠道: 1 星巴克APP 2饿了么APP 3 客诉单;
    int payWay = 0;
    QString deliveryTime = QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss"); //配送时间
    QString riderName = ""; //骑手名
    QString riderPhone = ""; //骑手电话
    QString createTime = "";
    QString confirmTime = "";
    QString acceptedDate = QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss"); //订单接单日期
    QString sendTime = "";
    QString finishTime = "";
    QString cancelTime = "";
    QString cancelReason = "";
    QString lang = ""; //语言（中文/英文）
    QString memo  = "";
    QString consumerRemark; // 客户备注;
    QString invoiceUrl = "";
    QString invoiceType = "";
    QString invoiceTitle = "";
    QString invoiceTaxpayerId  = "";
    QString firstName = ""; //用户名字；
    QString lastName = "";  //用户姓；
    QString longitude = "";
    QString latitude = "";
    QString street = "";
    QString consigneeName = ""; //收货人名
    QString consigneePhone = ""; //收货电话
    QString addressDetail = "";
    int orderIndex = 0;
    int updateTime = 0;
    QString customerSex = "";    //用户性别 1-男; 2-女
    QString platformSource = "";       //订单平台来源：1 app; 2 ele; 3 ors; 4 WeChat; 5 口碑; 6:?  7:?  8:Curbside-高德
    int needInvoice = 0;
    int deliveryPrice = 0;     // 配送费
    int deliveryDiscount = 0;  // 配送费折扣
    int disPlateformFee = 0;  // 平台优惠折扣；
    int packageFee = 0;      // 打包费
    int packDiscount = 0;    // 打包费折扣
    int isPackage = 0;        // MOP渠道: 是否打包: 0 不打包; 1:打包;
    QString packageSku = "";   // MOP渠道: 打包SKU;
    QString storeMakeSku = "";   //MOP渠道: 到店做SKU;
    QString secretSignal = ""; // MOP渠道：接头暗号;
    int orderDiscount = 0;    // 订单整单折扣金额
    int estimation = 0;       // 订单预计制作时间（单位:分钟）
    int appointmentDayFlag = 0;  // 预约当天标志 [0: 非预约当天(提前/延期)；1:预约当天(推送实物入机)]
    int productPrice = 0;
    int totalPrice = 0;
    int orderStatus = 0;
    QString makeStatus = "";        // PMS 制作状态
    QString makeSource = "";       //PMS 制作来源: 普通扫描枪、扫描枪Now、顾客、PMS-kds、
    QString makeDeviceId = "";    //PMS 更新制作状态的设备Id
    QString businessType = "0";   //订单业务类型:  10:预约单   20:杯贴祝福   30:拼团

    QString expectDate = "0000-00-00 00:00:00";                 // 预约时间 [预约单-顾客预计取餐时间] 必须设置默认值否则插库失败;
    QString reserveMakeTime = "0000-00-00 00:00:00";       // 预约制作时间【新增字段：string】
    int inAdvanceTakemeal = 0;        // 预约单提前到店标志【新增字段：int】
    QString subStoreId = "";           // 子门店号      【新增字段：string】
    int globalServiceType;            // 全链路服务类型: globalServiceType【新增字段：int】
    int globalOrderType;               // 全链路订单类型: globalOrderType   【新增字段：int】
    int forwardPosStatus = 0;  // 正向单入机状态： 0:未知  1: 成功  2:失败;
    int negativePosStatus = 0;  // 负向单同上;
    int isGiftitForward;                 // 1: 美好咖啡 ;   0: 普通wsg;
    QString remindTicketTime;  // 提醒小票时间
    QString carNumber;            // 车牌号
    QString privacyPhone;        // 隐私号
    QString  callBackUrl;   // 为阿里云配置新域名, 用于获取订单详情, 和汇报订单入机情况: 拉取订单详情成功时手动添加到订单json报文体中为了入机汇报接口;
    QString pcsCallbackUrl;   // 为走 O2O Fufillment Service 链路的EC-OMS新系统, PCS门店 Pad上操作订单状态变更 请求正确的 Url 地址;
    int extendType;                      // 20 Mod Plus 类型订单
    int deliveryProvider;               // 配送商户:  1-蜂鸟 , 2-美团
    int deliveryType;                     // 配送方式:  1-二轮车 , 2-四轮车
    bool skipPrint;                    // 上游推送的订单 是否跳过打印;
    bool deliveryAtProd;                       // 配送费已添加到商品列表标志;
    bool packageFeeAtProduct;            // 包装费已添加到商品列表标志;

    int deliveryStatus = 0;
    int payStatus = 0;
    int refundStatus = 0;
    int deliveryChannel = 0;
    int pushOrderType = 0;
    int pushOrderTimes = 0;
    int orsPushOrderType = 0;
    int orsPushOrderTimes = 0;
    bool isPush = false;
    bool isCancle = false;
    bool isORSPush = false;
    bool isORSCancle = false;
    //获取数据库中订单的标志数据;
    int dataBaseIsOrderExistInt  = 0;
    int dataBaseIsPushInt  = 0;
    int dataBaseIsCancleInt  = 0;
    int dataBaseIsORSPushInt = 0;
    int dataBaseIsORSCancleInt = 0;
    QString dataBasePosOrderCheckNo = "";

    QString getChannelName();

    QString getOrderStatusDec();

    inline QString getId()const{return id;}
    inline void setId(const QString& v){id = v;}

    inline QString getPayfmId()const{return payfmId;}
    inline void setPayfmId(const QString& v){payfmId = v;}

    inline QString getThirdPartyBatch()const{return thirdPartyBatch;}
    inline void setThirdPartyBatch(const QString& v){thirdPartyBatch = v;}

    inline QString getRefundFmId()const{return refundFmId;}
    inline void setRefundFmId(const QString& v){refundFmId = v;}

    inline QString getThirdPartyOrderId()const{return thirdPartyOrderId;}
    inline void setThirdPartyOrderId(const QString& v){thirdPartyOrderId = v;}

    inline int getOrderType()const{return orderType;}
    inline void setOrderType(const int& v){orderType = v;}

    inline QString getOrgOrderId()const{return orgOrderId;}
    inline void setOrgOrderId(const QString& v){orgOrderId = v;}

    inline QString getWaybillId()const{return waybillId;}
    inline void setWaybillId(const QString& v){waybillId = v;}

    inline QString getWatercourseId()const{return watercourseId;}
    inline void setWatercourseId(const QString& v){watercourseId = v;}

    inline QString getPickupCode()const{return pickupCode;}
    inline void setPickupCode(const QString& v){pickupCode = v;}

    inline QString getCustomerId()const{return customerId;}
    inline void setCustomerId(const QString& v){customerId = v;}

    inline QString getCustomerName()const{return customerName;}
    inline void setCustomerName(const QString& v){customerName = v;}

    inline QString getPhone()const{return phone;}
    inline void setPhone(const QString& v){phone = v;}

    inline QString getMsr_no()const{return msr_no;}
    inline void setMsr_no(const QString& v){msr_no = v;}

    inline QString getStoreId()const{return storeId;}
    inline void setStoreId(const QString& v){storeId = v;}

    inline QString getStoreName()const{return storeName;}
    inline void setStoreName(const QString& v){storeName = v;}

    inline QString getStoreAddress()const{return storeAddress;}
    inline void setStoreAddress(const QString& v){storeAddress = v;}

    inline QString getChannel()const{return channel;}
    inline void setChannel(const QString& v){channel = v;}

    inline int getPayWay()const{return payWay;}
    inline void setPayWay(const int& v){payWay = v;}

    inline QString getDeliveryTime()const{return deliveryTime;}
    inline void setDeliveryTime(const QString& v){deliveryTime = v;}

    inline QString getRiderName()const{return riderName;}
    inline void setRiderName(const QString& v){riderName = v;}

    inline QString getRiderPhone()const{return riderPhone;}
    inline void setRiderPhone(const QString& v){riderPhone = v;}

    inline QString getCreateTime()const{return createTime;}
    inline void setCreateTime(const QString& v){createTime = v;}

    inline QString getConfirmTime()const{return confirmTime;}
    inline void setConfirmTime(const QString& v){confirmTime = v;}

    inline QString getAcceptedDate()const{return acceptedDate;}
    inline void setAcceptedDate(const QString& v){acceptedDate = v;}

    inline QString getSendTime()const{return sendTime;}
    inline void setSendTime(const QString& v){sendTime = v;}

    inline QString getFinishTime()const{return finishTime;}
    inline void setFinishTime(const QString& v){finishTime = v;}

    inline QString getCancelTime()const{return cancelTime;}
    inline void setCancelTime(const QString& v){cancelTime = v;}

    inline QString getCancelReason()const{return cancelReason;}
    inline void setCancelReason(const QString& v){cancelReason = v;}

    inline QString getLang()const{return lang;}
    inline void setLang(const QString& v){lang = v;}

    inline QString getMemo()const{return memo;}
    inline void setMemo(const QString& v){memo = v;}

    inline QString getConsumerRemark() const { return consumerRemark; }
    inline void setConsumerRemark(const QString& v) { consumerRemark = v; }

    inline QString getInvoiceType()const{return invoiceType;}
    inline void setInvoiceType(const QString& v){invoiceType = v;}

    inline QString getInvoiceUrl()const{return invoiceUrl;}
    inline void setInvoiceUrl(const QString& v){invoiceUrl = v;}

    inline QString getInvoiceTitle()const{return invoiceTitle;}
    inline void setInvoiceTitle(const QString& v){invoiceTitle = v;}

    inline QString getInvoiceTaxpayerId()const{return invoiceTaxpayerId;}
    inline void setInvoiceTaxpayerId(const QString& v){invoiceTaxpayerId = v;}

    inline QString getFirstName()const{return firstName;}
    inline void setFirstName(const QString& v){firstName = v;}

    inline QString getLastName()const{return lastName;}
    inline void setLastName(const QString& v){lastName = v;}

    inline QString getLongitude()const{return longitude;}
    inline void setLongitude(const QString& v){longitude = v;}

    inline QString getLatitude()const{return latitude;}
    inline void setLatitude(const QString& v){latitude = v;}

    inline QString getStreet()const{return street;}
    inline void setStreet(const QString& v){street = v;}

    inline QString getConsigneeName()const{return consigneeName;}
    inline void setConsigneeName(const QString& v){consigneeName = v;}

    inline QString getConsigneePhone()const{return consigneePhone;}
    inline void setConsigneePhone(const QString& v){consigneePhone = v;}

    inline QString getAddressDetail()const{return addressDetail;}
    inline void setAddressDetail(const QString& v){addressDetail = v;}

    inline QString getPosCheckNo()const{return posCheckNo;}
    inline void setPosCheckNo(const QString& v){posCheckNo = v;}

    inline int getOrderIndex()const{return orderIndex;}
    inline void setOrderIndex(const int& v){orderIndex = v;}

    inline int getUpdateTime()const{return updateTime;}
    inline void setUpdateTime(const int& v){updateTime = v;}

    inline int getNeedInvoice()const{return needInvoice;}
    inline void setNeedInvoice(const int& v){needInvoice = v;}

    inline int getDeliveryPrice()const{return deliveryPrice;}
    inline void setDeliveryPrice(const int& v){deliveryPrice = v;}

    inline int getDeliveryDiscount()const{return deliveryDiscount;}
    inline void setDeliveryDiscount(const int& v){deliveryDiscount = v;}

    inline int getDisPlateformFee()const{return disPlateformFee;}
    inline void setDisPlateformFee(const int& v){disPlateformFee = v;}

    inline int getPackageFee()const{return packageFee;}
    inline void setPackageFee(const int& v){packageFee = v;}

    inline int getIsPackage()const{return isPackage;}
    inline void setIsPackage(const int& v){isPackage = v;}

    inline int getPackDiscount()const{return packDiscount;}
    inline void setPackDiscount(const int& v){packDiscount = v;}

    inline int getOrderDiscount()const{return orderDiscount;}
    inline void setOrderDiscount(const int& v){orderDiscount = v;}

    inline int getEstimation()const{return estimation;}
    inline void setEstimation(const int& v){estimation = v;}

    inline int getAppointmentDayFlag()const{return appointmentDayFlag;}
    inline void setAppointmentDayFlag(const int& v){appointmentDayFlag = v;}

    inline int getProductPrice()const{return productPrice;}
    inline void setProductPrice(const int& v){productPrice = v;}

    inline int getTotalPrice()const{return totalPrice;}
    inline void setTotalPrice(const int& v){totalPrice = v;}

    inline int getOrderStatus()const{return orderStatus;}
    inline void setOrderStatus(const int& v){orderStatus = v;}

    inline QString getMakeStatus()const{return makeStatus;}
    inline void setMakeStatus(const QString& v){makeStatus = v;}

    inline QString getMakeSource()const{return makeSource;}
    inline void setMakeSource(const QString& v){makeSource = v;}

    inline QString getMakeDeviceId()const{return makeDeviceId;}
    inline void setMakeDeviceId(const QString& v){makeDeviceId = v;}

    inline QString getBusinessType()const{return businessType;}
    inline void setBusinessType(const QString& v){businessType = v;}

    inline int getForwardPosStatus()const{return forwardPosStatus;}
    inline void setForwardPosStatus(const int& v){forwardPosStatus = v;}

    inline int getNegativePosStatus()const{return negativePosStatus;}
    inline void setNegativePosStatus(const int& v){negativePosStatus = v;}

    inline int getDeliveryStatus()const{return deliveryStatus;}
    inline void setDeliveryStatus(const int& v){deliveryStatus = v;}

    inline int getPayStatus()const{return payStatus;}
    inline void setPayStatus(const int& v){payStatus = v;}

    inline int getDeliveryChannel()const{return deliveryChannel;}
    inline void setDeliveryChannel(const int& v){deliveryChannel = v;}

    inline int getRefundStatus()const{return refundStatus;}
    inline void setRefundStatus(const int& v){refundStatus = v;}

    inline QString getCustomerSex()const{return customerSex;}
    inline void setCustomerSex(const QString& v){customerSex = v;}

    inline QString getPlatformSource()const{return platformSource;}
    inline void setPlatformSource(const QString& v){platformSource = v;}

    inline QString getPackageSku()const{return packageSku;}
    inline void setPackageSku(const QString& v){packageSku = v;}

    inline QString getStoreMakeSku()const{return storeMakeSku;}
    inline void setStoreMakeSku(const QString& v){storeMakeSku = v;}

    inline QString getSecretSignal()const{return secretSignal;}
    inline void setSecretSignal(const QString& v){secretSignal = v;}

    inline QString getExpectDate()const{return expectDate;}
    inline void setExpectDate(const QString& v){expectDate = v;}

    inline QString getReserveMakeTime()const{return reserveMakeTime;}
    inline void setReserveMakeTime(const QString& v){reserveMakeTime = v;}

    inline int getInAdvanceTakemeal()const{return inAdvanceTakemeal;}
    inline void setInAdvanceTakemeal(const int& v){inAdvanceTakemeal = v;}

    inline QString getSubStoreId()const{return subStoreId;}
    inline void setSubStoreId(const QString& v){subStoreId = v;}

    inline int getGlobalServiceType()const{return globalServiceType;}
    inline void setGlobalServiceType(const int& v){globalServiceType = v;}

    inline int getGlobalOrderType()const{return globalOrderType;}
    inline void setGlobalOrderType(const int& v){globalOrderType = v;}

    inline int getIsGiftitForward()const{return isGiftitForward;}
    inline void setIsGiftitForward(const int& v){isGiftitForward = v;}

    inline QString getRemindTicketTime()const{return remindTicketTime;}
    inline void setRemindTicketTime(const QString& v){remindTicketTime = v;}

    inline QString getCarNumber()const{return carNumber;}
    inline void setCarNumber(const QString& v){carNumber = v;}

    inline QString getPrivacyPhone()const{return privacyPhone;}
    inline void setPrivacyPhone(const QString& v){privacyPhone = v;}

    inline QString getCallBackUrl()const{return callBackUrl;}
    inline void setCallBackUrl(const QString& v){callBackUrl = v;}

    inline QString getPcsCallbackUrl()const{return pcsCallbackUrl;}
    inline void setPcsCallbackUrl(const QString& v){pcsCallbackUrl = v;}

    inline int getExtendType()const{return extendType;}
    inline void setExtendType(const int& v){extendType = v;}

    inline int getDeliveryProvider()const{return deliveryProvider;}
    inline void setDeliveryProvider(const int& v){deliveryProvider = v;}

    inline int getDeliveryType()const{return deliveryType;}
    inline void setDeliveryType(const int& v){deliveryType = v;}

    inline bool getSkipPrint()const{return skipPrint;}
    inline void setSkipPrint(const bool& v){skipPrint = v;}

    inline bool getDeliveryAtProd()const{return deliveryAtProd;}
    inline void setDeliveryAtProd(const bool& v){deliveryAtProd = v;}

    inline bool getPackageFeeAtProduct()const{return packageFeeAtProduct;}
    inline void setPackageFeeAtProduct(const bool& v){packageFeeAtProduct = v;}
};

#endif // ORDEROBJECT_H
