﻿#include "orderObject.h"
#include "preDefine.h"
#include "QsLog.h"
#include <QJsonArray>
OrderObject::OrderObject(const OrderObject &order, QObject *parent):QObject(parent)
{
    qDeleteAll(proList);
    proList.clear();
    qDeleteAll(coupList);
    coupList.clear();
    qDeleteAll(paymentList);
    paymentList.clear();
    const QMetaObject *m = order.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = order.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    foreach (auto ptr, order.proList) {
        dishesObject *product=new dishesObject(*ptr,this);
        this->proList.append(product);
    }
    foreach (auto ptr, order.coupList) {
        CouponsObject *coupon=new CouponsObject(*ptr,this);
        this->coupList.append(coupon);
    }
    foreach (auto ptr, order.paymentList) {
        PaymentObject *payment=new PaymentObject(*ptr,this);
        this->paymentList.append(payment);
    }
}

OrderObject& OrderObject::operator =(const OrderObject& order)
{
    qDeleteAll(proList);
    proList.clear();
    qDeleteAll(coupList);
    coupList.clear();
    qDeleteAll(paymentList);
    paymentList.clear();
    const QMetaObject *m = order.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = order.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    foreach (auto ptr, order.proList) {
        dishesObject *product=new dishesObject(*ptr,this);
        this->proList.append(product);
    }
    foreach (auto ptr, order.coupList) {
        CouponsObject *coupon = new CouponsObject(*ptr,this);
        this->coupList.append(coupon);
    }
    foreach (auto ptr, order.paymentList) {
        PaymentObject *payment=new PaymentObject(*ptr,this);
        this->paymentList.append(payment);
    }
    return *this;
}

void OrderObject::FromJson(const QJsonObject &json)
{
    qDeleteAll(proList);
    proList.clear();
    qDeleteAll(coupList);
    coupList.clear();
    qDeleteAll(paymentList);
    paymentList.clear();
    FetchDataFromJson(json);
    QJsonArray products = json[JSON_PRODUCTS].toArray();
    foreach(QJsonValue product, products)
    {
        QJsonObject proJson = product.toObject();
        dishesObject *proObject = new dishesObject(this);
        //初始商品数据信息;
        proObject->promotionQty = 0;
        proObject->promotionPrice = 0;
        proObject->starPromotionQty = 0;
        proObject->starPromotionPrice = 0;
        proObject->couponSeq=QString('0');
        proObject->FetchDataFromJson(proJson);
        proList.append(proObject);
    }
    //解析预约实物-券信息 List;
    QJsonArray coupons = json[JSON_COUPONS].toArray();
    foreach(QJsonValue coupon, coupons)
    {
        QJsonObject coupJson = coupon.toObject();
        CouponsObject *coupObject = new CouponsObject(this);
        coupObject->consumeDiscountAmount = 0;
        coupObject->consumeFactAmount = 0;
        coupObject->storeChannel = false;
        coupObject->name="";
        coupObject->couponSeq=QString('0');
        coupObject->isShowGiver=0;
        coupObject->FetchDataFromJson(coupJson);
        coupList.append(coupObject);
    }

    //解析多条支付方式信息 List;
    QJsonArray payments = json[JSON_PAYMENTS].toArray();
    foreach(QJsonValue payment, payments)
    {
        QJsonObject paymJson = payment.toObject();
        PaymentObject *paymObject = new PaymentObject(this);
        paymObject->paymentFmId="";
        paymObject->payMethodId="";
        paymObject->paymentMoney = 0;
        paymObject->FetchDataFromJson(paymJson);
        paymentList.append(paymObject);
    }
    return;
}

void OrderObject::FetchDataFromJson(const QJsonObject &json)
{
    QStringList keys = json.keys();
    foreach(QString key, keys)
    {
        setProperty(key.toUtf8(), json[key].toVariant());
    }
    return;
}

QString OrderObject::getChannelName()
{
    if ( "MOD" == channel ) {
        if (3 == orderType ) {
            return QString::fromLocal8Bit("星-客诉");
        } else if ( 7 == orderType  ) {
            return QString::fromLocal8Bit("预-MOD-当日");
        } else if ( 11 == orderType  ) {
            return QString::fromLocal8Bit("预-MOD-隔日");
        } else if ( 8 == orderType  ) {
            return QString::fromLocal8Bit("拼-MOD");
        } else if ( 89 == orderType ) {
            return QString::fromLocal8Bit("权益卡");
        } else {
            if ( "4" ==  platformSource ) {
                return QString::fromLocal8Bit("微信-MOD");
            } else {
                return QString::fromLocal8Bit("星-MOD");
            }
        }

    } else if ( "MT-MOD" == channel ) {
        if ( 7 == orderType ) {
            return QString::fromLocal8Bit("预-美团-当日");
        } else if ( 11 == orderType ) {
            return QString::fromLocal8Bit("预-美团-隔日");
        } else if ( 89 == orderType ) {
            return QString::fromLocal8Bit("权益卡");
        } else {
            return QString::fromLocal8Bit("美团-MOD");
        }

    } else if ("WSG-MOD" == channel ) { // 兼容渠道名称不统一问题
       if ( 1 == isGiftitForward ) {
           return QString::fromLocal8Bit("美好咖啡");
       } else {
           return QString::fromLocal8Bit("用星说");
       }

    } else if ("WSG-MOP" == channel) {
        if ( 1 == isGiftitForward ) {
            return QString::fromLocal8Bit("美好咖啡");
        } else {
            return QString::fromLocal8Bit("WSG-MOP");
        }

    } else if ("ELE" == channel) {
        if ( 7 == orderType  ) {
            return QString::fromLocal8Bit("预-饿了么-当日");
        } else if ( 11 == orderType  ) {
            return QString::fromLocal8Bit("预-饿了么-隔日");
        } else if ( 89 == orderType ) {
            return QString::fromLocal8Bit("权益卡");
        } else {
            return QString::fromLocal8Bit("饿了么");
        }

    } else if( "MOP" == channel ) {
        if (4 == orderType ) {
            return QString::fromLocal8Bit("星-自测");
        } else if ( 7 == orderType  ) {
            if ( "8" ==  platformSource ) {
                return QString::fromLocal8Bit("预-街送");
            }
            return QString::fromLocal8Bit("预-MOP-当日");

        } else if ( 11 == orderType  ) {
            return QString::fromLocal8Bit("预-MOP-隔日");
        } else if ( 8 == orderType  ) {
            return QString::fromLocal8Bit("拼-MOP");
        } else if (10 == orderType) {
            return QString::fromLocal8Bit("星时刻");
        } else if ( 89 == orderType ) {
            return QString::fromLocal8Bit("权益卡");
        } else {
            if ( "5" ==  platformSource ) {
                return QString::fromLocal8Bit("口碑-MOP");
            } else {
                return QString::fromLocal8Bit("星-MOP");
            }
        }

    } else if ( "MT-MOP" == channel ) {
        if ( 7 == orderType ) {
            return QString::fromLocal8Bit("预-美团-当日");
        } else if ( 11 == orderType ) {
            return QString::fromLocal8Bit("预-美团-隔日");
        } else if ( 89 == orderType ) {
            return QString::fromLocal8Bit("权益卡");
        } else {
            return QString::fromLocal8Bit("美团-MOP");
        }

    } else if ( "EC-MOP" == channel || "EC_WECHAT_MOP" == channel ) {
        return QString::fromLocal8Bit("电商MOP");

    }else{
        return QString::fromLocal8Bit("未知");
    }
}

QString OrderObject::getOrderStatusDec()
{
    switch(orderStatus)
    {
        case 1:return QString::fromLocal8Bit("下单待支付");
        case 2:return QString::fromLocal8Bit("已支付");
        case 3:return QString::fromLocal8Bit("接单");
        case 4:return QString::fromLocal8Bit("配送中");
        case 5:return QString::fromLocal8Bit("完成");
        case 6:return QString::fromLocal8Bit("取消");
        default: return QString::fromLocal8Bit("未知");
    }
    return QString::fromLocal8Bit("未知");
}
