﻿#ifndef DISHESOBJECT_H
#define DISHESOBJECT_H
#include <QObject>
#include <QJsonObject>
#include <QVariant>
#include <QMetaProperty>
class dishesObject : public QObject
{
    Q_OBJECT
    Q_PROPERTY (QString couponSeq READ getCouponSeq WRITE setCouponSeq)
    Q_PROPERTY (QString id READ getId WRITE setId)
    Q_PROPERTY (QString specId READ getspecId WRITE setspecId)
    Q_PROPERTY (QString name READ getname WRITE setname)
    Q_PROPERTY (QString enProductName READ getEnProductName WRITE setEnProductName)
    Q_PROPERTY (QString supplyChainSku READ getSupplyChainSku WRITE setSupplyChainSku)
    Q_PROPERTY (QString specName READ getspecName WRITE setspecName)
    Q_PROPERTY (QString enSpecificationName READ getEnSpecificationName WRITE setEnSpecificationName)
    Q_PROPERTY (QString defaultImage READ getDefaultImage WRITE setDefaultImage)
    Q_PROPERTY (QString code READ getcode WRITE setcode)
    Q_PROPERTY (int packagePrice READ getpackagePrice WRITE setpackagePrice)
    Q_PROPERTY (int sequence READ getSequence WRITE setSequence)
    Q_PROPERTY (int qty READ getqty WRITE setqty)
    Q_PROPERTY (int price READ getprice WRITE setprice)
    Q_PROPERTY (QString options READ getoptions WRITE setoptions)

    Q_PROPERTY (QString promotionSku READ getpromotionSku WRITE setpromotionSku)
    Q_PROPERTY (QString promotionName READ getpromotionName WRITE setpromotionName)
    Q_PROPERTY (int promotionQty READ getpromotionQty WRITE setpromotionQty)
    Q_PROPERTY (int promotionPrice READ getpromotionPrice WRITE setpromotionPrice)

    Q_PROPERTY (QString starPromotionSku READ getStarPromotionSku WRITE setStarPromotionSku)
    Q_PROPERTY (QString starPromotionName READ getStarPromotionName WRITE setStarPromotionName)
    Q_PROPERTY (int starPromotionQty READ getStarPromotionQty WRITE setStarPromotionQty)
    Q_PROPERTY (int starPromotionPrice READ getStarPromotionPrice WRITE setStarPromotionPrice)

    Q_PROPERTY (QString userName READ getUserName WRITE setUserName)
    Q_PROPERTY (QString wechatName READ getWechatName WRITE setWechatName)

public:
    explicit dishesObject(QObject *parent = 0):QObject(parent){}
    dishesObject(const dishesObject& dish,QObject* parent=0);
    dishesObject& operator =(const dishesObject& dish);
    void FetchDataFromJson(const QJsonObject &json);
    QString couponSeq = ""; //券序号
    QString id = "";
    QString name = "";
    QString enProductName = ""; //英文版商品名称;
    QString supplyChainSku;   // EC-MOP 渠道订单商品的SKU
    QString specId = "";
    QString specName = "";
    QString enSpecificationName = ""; //英文版规格名称;
    QString defaultImage = ""; //商品默认图片;
    QString code = "";
    int qty = 0;
    int packagePrice = 0;
    int price = 0;
    int sequence = 0;
    QString options = "";
    //卡券/红包优惠;
    QString promotionSku = "";
    QString promotionName = "";
    int promotionQty = 0;
    int promotionPrice = 0;
    //星星优惠;
    QString starPromotionSku = "";
    QString starPromotionName = "";
    int starPromotionQty = 0;
    int starPromotionPrice = 0;
    QString userName = "";
    QString wechatName = "" ;  // 拼单-微信昵称;

    QList<dishesObject*> sub_products;

protected:
    inline QString getCouponSeq(){ return couponSeq; }
    inline void setCouponSeq(const QString& v){ couponSeq = v; }

    inline QString getId(){ return id; }
    inline void setId(const QString& v){ id = v; }

    inline QString getspecId(){ return specId; }
    inline void setspecId(const QString& v){ specId = v; }

    inline QString getname(){ return name; }
    inline void setname(const QString& v){ name = v; }

    inline QString getEnProductName(){ return enProductName; }
    inline void setEnProductName(const QString& v){ enProductName = v; }

    inline QString getSupplyChainSku(){ return supplyChainSku; }
    inline void setSupplyChainSku(const QString& v){ supplyChainSku = v; }

    inline int getprice(){ return price; }
    inline void setprice(const int& v){ price = v; }

    inline QString getoptions(){ return options; }
    inline void setoptions(const QString& v){ options = v; }

    inline int getpackagePrice(){ return packagePrice; }
    inline void setpackagePrice(const int& v){ packagePrice = v; }

    inline int getSequence(){ return sequence; }
    inline void setSequence(const int& v){ sequence = v; }

    inline QString getspecName(){ return specName; }
    inline void setspecName(const QString& v){ specName = v; }

    inline QString getEnSpecificationName(){ return enSpecificationName; }
    inline void setEnSpecificationName(const QString& v){ enSpecificationName = v; }

    inline QString getDefaultImage(){ return defaultImage; }
    inline void setDefaultImage(const QString& v){ defaultImage = v; }

    inline QString getcode(){ return code; }
    inline void setcode(const QString& v){ code = v; }

    inline int getqty(){ return qty; }
    inline void setqty(const int& v){ qty = v; }


    inline QString getpromotionSku(){ return promotionSku; }
    inline void setpromotionSku(const QString& v){ promotionSku = v; }

    inline QString getpromotionName(){ return promotionName; }
    inline void setpromotionName(const QString& v){ promotionName = v; }

    inline int getpromotionPrice(){ return promotionPrice; }
    inline void setpromotionPrice(const int& v){ promotionPrice = v; }

    inline int getpromotionQty(){ return promotionQty; }
    inline void setpromotionQty(const int& v){ promotionQty = v; }


    inline QString getStarPromotionSku(){ return starPromotionSku; }
    inline void setStarPromotionSku(const QString& v){ starPromotionSku = v; }

    inline QString getStarPromotionName(){ return starPromotionName; }
    inline void setStarPromotionName(const QString& v){ starPromotionName = v; }

    inline int getStarPromotionPrice(){ return starPromotionPrice; }
    inline void setStarPromotionPrice(const int& v){ starPromotionPrice = v; }

    inline int getStarPromotionQty(){ return starPromotionQty; }
    inline void setStarPromotionQty(const int& v){ starPromotionQty = v; }

    inline QString getUserName(){ return userName; }
    inline void setUserName(const QString& v){ userName = v; }

    inline QString getWechatName(){ return wechatName; }
    inline void setWechatName(const QString& v){ wechatName = v; }

};

#endif // DISHESOBJECT_H
