﻿#include "dishesObject.h"
#include "preDefine.h"
#include <QJsonArray>


dishesObject::dishesObject(const dishesObject &dish, QObject *parent):QObject(parent)
{
    qDeleteAll(sub_products);
    sub_products.clear();
    const QMetaObject *m = dish.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = dish.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    foreach (auto ptr, dish.sub_products) {
        dishesObject *product=new dishesObject(*ptr,this);
        this->sub_products.append(product);
    }
}

dishesObject& dishesObject::operator =(const dishesObject& dish)
{
    qDeleteAll(sub_products);
    sub_products.clear();
    const QMetaObject *m = dish.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = dish.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    foreach (auto ptr, dish.sub_products) {
        dishesObject *product=new dishesObject(*ptr,this);
        this->sub_products.append(product);
    }
    return *this;
}

void dishesObject::FetchDataFromJson(const QJsonObject &json)
{
    foreach(QString key,  json.keys())
    {
        setProperty(key.toUtf8(), json[key].toVariant());
    }

    qDeleteAll(sub_products);
    sub_products.clear();
    QJsonArray subDishesArray = json[JSON_SUBPRODUCTS].toArray();
    foreach(QJsonValue subDish, subDishesArray)
    {
        dishesObject *item = new dishesObject(this);
        //初始商品配料数据信息;
        item->promotionQty=0;
        item->promotionPrice=0;
        item->starPromotionQty=0;
        item->starPromotionPrice=0;
        item->couponSeq=QString('0');

        item->FetchDataFromJson(subDish.toObject());
        sub_products.append(item);
    }
    return;
}
