﻿#include "baseObject.h"
#include <QStringList>
#include <QVariant>
#include "preDefine.h"

BaseObject::BaseObject(const BaseObject &p, QObject *parent)
{
    Q_UNUSED(parent);
    const QMetaObject *m = p.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = p.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
}

BaseObject &BaseObject::operator =(const BaseObject &p)
{
    const QMetaObject *m = p.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = p.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    return *this;
}

void BaseObject::FetchDataFromJson(const QJsonObject &json)
{
    QStringList keys = json.keys();
    foreach(QString key, keys)
    {
        setProperty(key.toUtf8(), json[key].toVariant());
    }

    return;
}
