﻿/******************
*进行sqlite操作
******************/
#ifndef SIMPROCORDERDB_H
#define SIMPROCORDERDB_H
#include <QtSql/QSqlDatabase>
#include <QtSql/QSqlQuery>
#include <QtSql/QSqlError>
#include <QObject>
#include <QMutex>

class SimProcOrderDB : public QObject
{
    Q_OBJECT
public:
   // explicit SimProcOrderDB(QObject *parent = 0);

    static SimProcOrderDB& getInstance();

    /**
    *功能:初始化数据库
    *参数:[1]订单号 [2]创建时间
    */
    bool initSimProcOrderDB();

    /**
    *功能:修改 SimProcOrderDB表中 orderId字段长度[20->50];
    *参数:[无]
    *返回:true:修改成功，false:修改失败
    **/
    bool alterTableSimProcOrderDB();

    /**
    *功能:插入一条Simphony返回小票号的订单新数据
    *参数:[1]订单号 [2]创建时间
    *返回:true操作成功，false失败
    **/
    bool insertSimProcOrder(const QString& orderId, const QString &creatTime);

    /**
    *功能:更新推单的入账状态[POS录单状态:订单录销售单的意思；同时也用来标记POS是否打印过录单小票]
    *参数:[1]订单号[2]入账状态(目前情况都是"1")
    *返回:true操作成功，false失败
    **/
    bool updatePushOrderStatus(const QString& orderId, const int &pushOrderStatus);

    /**
    *功能:查订单在数据库中的标志性数据；
    *参数:[1]订单号 [2]订单是否存在 [3]是否销售单 [4]是否退货单 [5]是否ORS销售单 [6]是否ORS退货单 [7]订单对应小票号;
    *返回:true:获取成功，false:获取失败;
    **/
    bool getDbOrderAllFlag(const QString& id, int& dataBaseIsOrderExistInt, int& dataBaseIsPushInt,
     int& dataBaseIsCancleInt, int& dataBaseIsORSPushInt, int& dataBaseIsORSCancleInt, QString& dataBasePosOrderCheckNo);

    /**
    *功能:查询是否入账[POS新单录单：即模拟Simphony点单是否成功：成功:TRUE;未成功:FALSE]
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isPushedOrder(const QString& orderId);

    /**
    *功能:更新退款入账状态[POS退款录单状态:订单录退款单的意思；同时也用来标记POS是否打印过退款单小票]
    *参数:[1]订单号[2]退款入账状态
    *返回:true操作成功，false失败
    **/
    bool updateRefundOrderStatus(const QString& orderId, const int &refundOrderStatus);

    /**
    *功能:查询是否退款入账[POS退款录单：即模拟Simphony退单是否成功：成功:TRUE;未成功:FALSE]
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isRefundOrder(const QString& orderId);

    /**
    *功能:更新 预约实物销售单入机状态[标记POS是否打印过预约实物销售单小票]
    *参数:[1]订单号[2]预约实物销售单入机状态
    *返回:true操作成功，false失败
    **/
    bool updateORSPushOrderStatus(const QString& orderId, const int &ORSPushOrderStatus);

    /**
    *功能:查询 预约实物销售单 是否入机成功 [即模拟Simphony录入预约实物是否成功：成功:TRUE;未成功:FALSE]
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isORSPushOrder(const QString& orderId);

    /**
    *功能:更新 预约实物退货入机状态[标记POS是否打印过预约实物退货单小票]
    *参数:[1]订单号[2]预约实物退货单入机状态
    *返回:true操作成功，false失败
    **/
    bool updateORSCancleOrderStatus(const QString& orderId, const int &ORSCancleOrderStatus);

    /**
    *功能:查询 预约实物退货 是否入机成功 [即模拟Simphony录入预约实物退货是否成功：成功:TRUE;未成功:FALSE]
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isORSCancleOrder(const QString& orderId);


    /**
    *功能:更新汇报入账状态 [POS汇报入账状态:录订单汇报的意思；同时也用来标记POS是否?????????]
    *参数:[1]订单号[2]汇报入账状态
    *返回:true操作成功，false失败
    **/
    bool updateReportOrderStatus(const QString& orderId, const int &reportOrderStatus);

    /**
    *功能:查询是否汇报入账 [POS订单是否汇报入账：判断Simphony 汇报入单是否成功：成功:TRUE;未成功:FALSE]
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isReportOrder(const QString& orderId);

    /**
    *功能:更新back汇报入账状态[POS汇报入账状态:录订单汇报的意思；同时也用来标记POS是否?????????]
    *参数:[1]订单号[2]汇报入账状态
    *返回:true操作成功，false失败
    **/
    bool updateBackReportOrderStatus(const QString& orderId, const int &backReportOrderStatus);

    /**
    *功能:查询是否back汇报入账 [POS订单是否汇报入账：判断Simphony 汇报入单是否成功：成功:TRUE;未成功:FALSE]
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isBackReportOrder(const QString& orderId);

    /**
    *功能:查询订单是否存在
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isOrderExist(const QString& orderId);

    /**
    *功能:更新订单的pos小票号；
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool updatePosOrderCheckNo(const QString& orderId, const QString &posOrderCheckNo);

    /**
    *功能:获取订单的pos小票号；
    *参数:[1]订单号 [2]带出参数：用来存放参数1对应的小票号的值;
    *返回：true是，false否
    **/
    bool getPosOrderCheckNo(const QString& orderId, QString &posOrderCheckNo);

    bool queryValue(const QString& orderId, const QString& key, QString& error, QVariant &value);

    bool updatekey(const QString& orderId, const QString& key, const int value, QString &error, bool &result);

    bool queryIsNull(const QString &orderId, const QString& key,QString &error, bool &result);

    /**
    *功能:删除指定时间的订单记录
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool deleteOrderRecord(QString creatTime);
private:
    QMutex m_mutex;
    SimProcOrderDB();
    SimProcOrderDB(SimProcOrderDB const&);
    SimProcOrderDB& operator=(SimProcOrderDB const&);
    QSqlDatabase m_sqlDb;

signals:

public slots:
};

#endif // SIMPROCORDERDB_H
