﻿#include "simProcOrderDB.h"
#include "QsLog.h"
#include "preDefine.h"
#include <QCoreApplication>

SimProcOrderDB::SimProcOrderDB()
{
   QLOG_INFO()<<"[<<<<---SimProcOrderDB:: Structure Order Push and Refund DataBase--->>>>]";
}

bool SimProcOrderDB::initSimProcOrderDB(){
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::initSimProcOrderDB Try Lock Failed--->>>>]";
        return false;
    }
    bool bRet = false;
    m_sqlDb=QSqlDatabase::addDatabase("QMYSQL","SimProcOrderDB"); //数据库驱动类型为Mysql;
    if(m_sqlDb.isValid()){
        QLOG_INFO()<<"[<<<<---SimProcOrderDB:: driver is valid--->>>>]";
        /*
        QString dsn="DRIVER={SQL SERVER};SERVER=127.0.0.1\\sqlexpress;DATABASE=MMXBenefits";
        // Win10不支持属性: ;Trusted_Connection=yes ; 必须取消此属性,否则 QODBC3: Unable to connnet;
        m_sqlDb.setDatabaseName(dsn);                            //设置数据源名称
        m_sqlDb.setUserName("sa");                               //登录用户
        m_sqlDb.setPassword("SIM29@123");
        */

        //PMS No Use;
        /*
        m_sqlDb.setHostName("127.0.0.1");      //连接数据库主机名，这里需要注意（若填的为”127.0.0.1“，出现不能连接，则改为localhost)
        m_sqlDb.setPort(3306);                 //连接数据库端口号，与设置一致
        m_sqlDb.setDatabaseName("pms");        //连接数据库名，与设置一致
        m_sqlDb.setUserName("oms");           //数据库用户名，与设置一致
        m_sqlDb.setPassword("starbucks@oms");         //数据库密码，与设置一致
        */

        if(!m_sqlDb.open()) {                                      //打开数据库
            QLOG_ERROR()<<"[<<<<---SimProcOrderDB:: Open Database error:--->>>>]"<<m_sqlDb.lastError().text();
            bRet = false;
        } else {
            QLOG_INFO()<<"[<<<<---SimProcOrderDB:: Test Open database success!:--->>>>]";
            QSqlQuery query(m_sqlDb);
            QString selectsql ="select table_name from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA='pms' and TABLE_NAME='SimProcOrderTable'" ;
            if(!query.exec(selectsql)) {
                QLOG_ERROR()<<"[<<<<---SimProcOrderDB:: Database  check table SimProcOrderTable command failed--->>>>]"<<query.lastError().text();
            }
            if(query.next()) {
                QLOG_INFO() << "[<<<<---SimProcOrderDB::Table SimProcOrderTable Has Exist--->>>>]";
            } else {
                QLOG_INFO() << "[<<<<---SimProcOrderDB::Table SimProcOrderTable Does Not Exist--->>>>]";
                //在此征用:isReport 字段为 预约实物 销售入机标志;在此征用:isBackReport 字段为 预约实物 退货入机标志;
                query.prepare(QString("create table SimProcOrderTable ( orderId  varchar(50) primary key,isPushed int,isRefund int,isReport int,isBackReport int,posCheckNo varchar(20),creatTime varchar(20) )"));
                if(!query.exec()){
                    QLOG_ERROR()<< "[<<<<---Create Table SimProcOrderTable Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
                    bRet = false;
                }
            }
            m_sqlDb.close();
            bRet = true;
        }
    } else {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB:: driver no valid";
        bRet = false;
    }

    if(bRet) {
        /*
        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---SimProcOrderDB::FM TakeOut Plugin Version:2.20193**.1 Begin Alter Column orderId--->>>>]");
        bRet = alterTableSimProcOrderDB();
        */
        m_mutex.unlock();
        return bRet;
    } else {
        m_mutex.unlock();
        return bRet;
    }
}

bool SimProcOrderDB::alterTableSimProcOrderDB(){
    //QMutexLocker mutex(&m_mutex); 被 initSimProcOrderDB 调用  顾不用加锁，否则死锁；
    int alterSuccessNum = 0;
    QString PrimaryKeyName = "";
    QSqlQuery query(m_sqlDb);
    QString selectsql;
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::alterTableSimProcOrderDB ::SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }
    // 1、Select The Length Of Table Column orderId;
    selectsql = "select length  from syscolumns where id=object_id('SimProcOrderTable') and name='orderId'";
    query.exec(selectsql);
    if(query.first()){
        if(50==query.value(0).toInt()){
            QLOG_INFO()<< "[<<<<---SimProcOrderDB::Length Of SimProcOrderTable Column orderId Is 50, No Need Proc PrimaryKey,Return True --->>>>]" <<query.value(0).toInt();
            m_sqlDb.close();
            return true;
        } else {
            QLOG_ERROR()<< "[<<<<---SimProcOrderDB::Length Of SimProcOrderTable Column orderId Not 50,Need Alter Length Of orderId --->>>>]" <<query.value(0).toInt();
        }
    } else {
        QLOG_ERROR()<< "[<<<<---SimProcOrderDB::Select Length Of SimProcOrderTable Column orderId Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
    }

    // 2、Select The Name Of Table PrimaryKey Constraint;
    selectsql = "select name from SYS.OBJECTS WHERE TYPE_DESC='PRIMARY_KEY_CONSTRAINT' AND PARENT_OBJECT_ID in (SELECT OBJECT_ID FROM SYS.OBJECTS WITH(NOLOCK) WHERE NAME='SimProcOrderTable')";
    query.exec(selectsql);
    if(query.first()){
        PrimaryKeyName = query.value(0).toString();
        QLOG_INFO()<< "[<<<<---SimProcOrderDB::SimProcOrderTable PrimaryKey Constraint Name --->>>>]" <<query.value(0).toString();
        if(PrimaryKeyName.length()){ alterSuccessNum++; }
    } else {
        QLOG_ERROR()<< "[<<<<---SimProcOrderDB::Get SimProcOrderTable PrimaryKey Constraint Name Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
    }

    // 3、Drop Table PrimaryKey Constraint;
    selectsql = "ALTER TABLE SimProcOrderTable DROP CONSTRAINT " + PrimaryKeyName;
    if( !query.exec(selectsql) ){
       QLOG_ERROR()<< "[<<<<---SimProcOrderDB::Drop Table PrimaryKey Constraint Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
    } else { alterSuccessNum++;}

    // 4、Alter Table Column orderId Length 20->50;
    selectsql = "alter table SimProcOrderTable alter column orderId varchar(50) not null;";
    if(!query.exec(selectsql)){
       QLOG_ERROR()<< "[<<<<---SimProcOrderDB::alter table SimProcOrderTable orderId Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
    } else { alterSuccessNum++;}

    // 5、Create Table PrimaryKey Constraint;
    selectsql = "alter table SimProcOrderTable add constraint orderIdPrimaryKey primary key(orderId)";
    if( !query.exec(selectsql) ){
        QLOG_ERROR()<< "[<<<<---SimProcOrderDB::Create Table PrimaryKey Constraint Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
    } else { alterSuccessNum++;}

    m_sqlDb.close();
    if (4 == alterSuccessNum) {
        QLOG_INFO()<<"[<<<<---SimProcOrderDB::alterTableSimProcOrderDB::alterSuccessNum = 4 --->>>>]";
        return true;
    } else {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::alterTableSimProcOrderDB::alterSuccessNum < 4 = --->>>>]"<<alterSuccessNum;
        return false;
    }
}

SimProcOrderDB &SimProcOrderDB::getInstance()
{
    static SimProcOrderDB simProcOrderDB;
    return simProcOrderDB;
}

bool SimProcOrderDB::insertSimProcOrder(const QString &orderId,const QString& creatTime)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::insertSimProcOrder Try Lock Failed--->>>>]";
        return false;
    }

    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::insertSimProcOrder Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("insert into SimProcOrderTable values('%1',0,0,0,0,NUll,'%6')").arg(orderId).arg(creatTime));
    if(!query.exec()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB:insertSimProcOrder Error--->>>>]"<<query.lastError().text()<<QString::number(query.lastError().type());
        result = false;
    } else {
        QLOG_INFO()<<QString("[<<<<---SimProcOrderDB:: Insert OrderId %1 Into SimProcOrderTable Success--->>>>]").arg(orderId);
        result = true;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

bool SimProcOrderDB::updatePushOrderStatus(const QString &orderId, const int &pushOrderStatus)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updatePushOrderStatus Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updatePushOrderStatus Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("update SimProcOrderTable set isPushed=%1 where orderId='%2'")
                  .arg(QString::number(pushOrderStatus)).arg(orderId));
    if(!query.exec())
    {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updatePushOrderStatus Failed--->>>>]"<<query.lastError().text();
        result= false;
    } else {
        QLOG_INFO()<<QString("[<<<<---SimProcOrderDB::Update OrderId %1 pushOrderStatus success;pushOrderStatus:%2--->>>>]").arg(orderId).arg(pushOrderStatus);
        result = true;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}


bool SimProcOrderDB::getDbOrderAllFlag(const QString& id, int& dataBaseIsOrderExistInt, int& dataBaseIsPushInt, int& dataBaseIsCancleInt,
                                        int& dataBaseIsORSPushInt, int& dataBaseIsORSCancleInt, QString& dataBasePosOrderCheckNo){
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::getDbOrderAllFlag Try Lock Failed--->>>>]";
        return false;
    }

    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::getDbOrderAllFlag Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);

    query.prepare(QString("select orderId,isPushed,isRefund,isReport,isBackReport, posCheckNo from SimProcOrderTable where orderId='%1'").arg(id));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<id<<"[<<<<---SimProcOrderDB::isOrderExit Failed--->>>>]";
        result= false;
    }
    if(query.first()) {
        dataBaseIsOrderExistInt = 1;
        dataBaseIsPushInt = query.value(1).toInt();
        dataBaseIsCancleInt = query.value(2).toInt();
        dataBaseIsORSPushInt = query.value(3).toInt();
        dataBaseIsORSCancleInt = query.value(4).toInt();
        dataBasePosOrderCheckNo = query.value(5).toString();
        result= true;
    } else {
        result = true;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;

}


bool SimProcOrderDB::isPushedOrder(const QString &orderId)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isPushedOrder Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isPushedOrder  Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select isPushed from SimProcOrderTable where orderId='%1'").arg(orderId));
    if(!query.exec()){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isPushedOrder Failed--->>>>]"<<query.lastError().text()<<orderId;
        result= false;
    }
    while(query.next()) {
        result= query.value(0).toBool();
        QLOG_INFO()<<QString("[<<<<---SimProcOrderDB::isPushedOrder  orderId:%1  isPushedOrder:%2  --->>>>]").arg(orderId).arg(result);
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

bool SimProcOrderDB::updateRefundOrderStatus(const QString &orderId, const int &refundOrderStatus)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateRefundOrderStatus Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateRefundOrderStatus  Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("update SimProcOrderTable set isRefund=%1 where orderId='%2'")
                  .arg(QString::number(refundOrderStatus)).arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateRefundOrderStatus Failed--->>>>]"<<query.lastError().text();
        result= false;
    } else {
        QLOG_INFO()<<QString("[<<<<---SimProcOrderDB::Update OrderId %1 refundOrderStatus Successd; refundOrderStatus:%2  --->>>>]").arg(orderId).arg(refundOrderStatus);
        result = true;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

bool SimProcOrderDB::isRefundOrder(const QString &orderId)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isRefundOrder Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isRefundOrder Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select isRefund from SimProcOrderTable where orderId='%1'").arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<orderId<<"[<<<<---SimProcOrderDB::isRefundOrder Failed--->>>>]"<<query.lastError().text();
        result= false;
    }
    while(query.next()) {
        result= query.value(0).toBool();
        QLOG_INFO()<<QString("[<<<<---SimProcOrderDB::isRefundOrder:  orderId:%1, isRefundOrder:%2--->>>>]").arg(orderId).arg(result);
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

//征用isReport 数据库字段用来标志 预约实物 销售单 是否已经入机;
bool SimProcOrderDB::updateORSPushOrderStatus(const QString &orderId, const int &ORSPushOrderStatus)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateORSPushOrderStatus Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateORSPushOrderStatus Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("update SimProcOrderTable set isReport=%1 where orderId='%2'")
                  .arg(QString::number(ORSPushOrderStatus)).arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateORSPushOrderStatus Failed--->>>>]"<<query.lastError().text();
        result= false;
    } else {
        QLOG_INFO()<<QString("[<<<<---SimProcOrderDB::updateORSPushOrderStatus Update OrderId %1 ORSPushOrderStatus-isReport Success--->>>>]").arg(orderId);
        result = true;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

//征用isReport 数据库字段用来标志 预约实物 销售单 是否已经入机;
bool SimProcOrderDB::isORSPushOrder(const QString &orderId)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isORSPushOrder Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isORSPushOrder Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select isReport from SimProcOrderTable where orderId='%1'").arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<orderId<<"[<<<<---SimProcOrderDB::isORSPushOrder Failed--->>>>]";
        result= false;
    }
    while(query.next()) {
        result= query.value(0).toBool();
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

//征用 isBackReport 数据库字段用来标志 预约实物 退货单 是否已经入机;
bool SimProcOrderDB::updateORSCancleOrderStatus(const QString &orderId, const int &ORSCancleOrderStatus)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateORSCancleOrderStatus Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateORSCancleOrderStatus Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("update SimProcOrderTable set isBackReport=%1 where orderId='%2'")
                  .arg(QString::number(ORSCancleOrderStatus)).arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateORSCancleOrderStatus Failed--->>>>]"<<query.lastError().text();
        result= false;
    } else {
        QLOG_INFO()<<QString("[<<<<---SimProcOrderDB::updateORSCancleOrderStatus Update OrderId %1 ORSCancleOrderStatus-isBackReport Success--->>>>]").arg(orderId);
        result = true;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

//征用 isBackReport 数据库字段用来标志 预约实物 退货单 是否已经入机;
bool SimProcOrderDB::isORSCancleOrder(const QString &orderId)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isORSCancleOrder Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isORSCancleOrder Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select isBackReport from SimProcOrderTable where orderId='%1'").arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<orderId<<"[<<<<---SimProcOrderDB::isORSCancleOrder Failed--->>>>]";
        result= false;
    }
    while(query.next()) {
        result= query.value(0).toBool();
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

bool SimProcOrderDB::updateReportOrderStatus(const QString &orderId, const int &reportOrderStatus)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateReportOrderStatus Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateReportOrderStatus Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("update SimProcOrderTable set isReport=%1 where orderId='%2'")
                  .arg(QString::number(reportOrderStatus)).arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateReportOrderStatus Failed--->>>>]"<<query.lastError().text();
        result= false;
    } else {
        QLOG_INFO()<<QString("[<<<<---SimProcOrderDB::Update OrderId %1 reportOrderStatus Success--->>>>]").arg(orderId);
        result = true;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

bool SimProcOrderDB::isReportOrder(const QString &orderId)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isReportOrder Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isReportOrder Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select isReport from SimProcOrderTable where orderId='%1'").arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<orderId<<"[<<<<---SimProcOrderDB::isReportOrder Failed--->>>>]";
        result= false;
    }
    while(query.next()) {
        result= query.value(0).toBool();
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

bool SimProcOrderDB::updateBackReportOrderStatus(const QString &orderId, const int &backReportOrderStatus)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateBackReportOrderStatus Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updateBackReportOrderStatus Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("update SimProcOrderTable set isBackReport=%1 where orderId='%2'")
                  .arg(QString::number(backReportOrderStatus)).arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<"[<<<<---SimProcOrderDB::updateBackReportOrderStatus Failed--->>>>]";
        result= false;
    } else {
        QLOG_INFO()<<QString("[<<<<---SimProcOrderDB::Update OrderId %1 backReportOrderStatus Success--->>>>]").arg(orderId);
        result = true;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

bool SimProcOrderDB::isBackReportOrder(const QString &orderId)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isBackReportOrder Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isBackReportOrder Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select isBackReport from SimProcOrderTable where orderId='%1'").arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<orderId<<"[<<<<---SimProcOrderDB::isBackReportOrder Failed--->>>>]";
        result= false;
    }
    while(query.next()) {
        result= query.value(0).toBool();
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}
bool SimProcOrderDB::isOrderExist(const QString &orderId)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isOrderExist Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::isOrderExist Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select orderId from SimProcOrderTable where orderId='%1'").arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<orderId<<"[<<<<---SimProcOrderDB::isOrderExit Failed--->>>>]";
        result= false;
    }
    if(query.first()) {
        result= true;
    } else {
        result = false;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

bool SimProcOrderDB::updatePosOrderCheckNo(const QString &orderId, const QString &posOrderCheckNo)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updatePosOrderCheckNo Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::updatePosOrderCheckNo Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("update SimProcOrderTable set posCheckNo='%1' where orderId='%2'")
                  .arg(posOrderCheckNo).arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<__FUNCTION__;
        result= false;
    } else {
        QLOG_INFO()<<QString("[<<<<---SimProcOrderDB::Action4: Report CheckNo : Update OrderId:%1 posCheckNo:%2 Success--->>>>]").arg(orderId).arg(posOrderCheckNo);
        result = true;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

bool SimProcOrderDB::getPosOrderCheckNo(const QString &orderId,QString& posOrderCheckNo)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::getPosOrderCheckNo Try Lock Failed--->>>>]";
        return false;
    }
    bool result=false;
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::getPosOrderCheckNo Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return result;
    }
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select posCheckNo from SimProcOrderTable where orderId='%1'").arg(orderId));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<orderId<<__FUNCTION__;
        return result;
    }
    while(query.next()) {
        posOrderCheckNo= query.value(0).toString();
        result=true;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}

bool SimProcOrderDB::deleteOrderRecord(QString creatTime)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::deleteOrderRecord Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SimProcOrderDB::deleteOrderRecord Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result=true;
    QLOG_INFO()<<QString("[<<<<---SimProcOrderDB::begin deleteOrderRecord creatTime:%1--->>>>]").arg(creatTime);
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("delete from SimProcOrderTable where creatTime<'%1'").arg(creatTime));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<__FUNCTION__;
        result= false;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}


bool SimProcOrderDB::queryValue(const QString &orderId, const QString& key,  QString &error, QVariant & value)
{
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        error.append(QString("SimProcOrderDB::queryValue :Open Failed").append(m_sqlDb.lastError().text()));
        return false;
    }
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select %1 from SimProcOrderTable where orderId='%1'").arg(key).arg(orderId));
    if(!query.exec()) {
        error.append(query.lastError().text());
        m_sqlDb.close();
        return false;
    } else {
        while(query.next())
        {
            value= query.value(0);
        }
    }
    m_sqlDb.close();
    return true;
}

bool SimProcOrderDB::updatekey(const QString &orderId, const QString &key, const int value,  QString &error, bool &result)
{
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        error.append(QString("SimProcOrderDB::updatekey :Open Failed").append(m_sqlDb.lastError().text()));
        return false;
    }
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("update SimProcOrderTable set %1=%2 where orderId='%3'").arg(key)
                  .arg(QString::number(value)).arg(orderId));
    if(!query.exec()) {
        error.append(query.lastError().text());
        m_sqlDb.close();
        return false;
    } else {
        result = true;
    }
    m_sqlDb.close();
    return true;
}

bool SimProcOrderDB::queryIsNull(const QString &orderId, const QString &key, QString &error, bool &result)
{
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        error.append(QString("SimProcOrderDB::queryIsNull Open Failed").append(m_sqlDb.lastError().text()));
        return false;
    }
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select %1 from SimProcOrderTable where orderId=%2 and %3 is null").arg(orderId,orderId,key));
    if(!query.exec()) {
        error.append(query.lastError().text());
        m_sqlDb.close();
        return false;
    } else {
        if(query.first()) {
            result= true;
        } else {
            result = false;
        }
    }
    m_sqlDb.close();
    return true;
}

