/******************
*进行 Redis 操作 [单例]
******************/
#ifndef QTREDISCLIENT_H
#define QTREDISCLIENT_H

#include "qredisclient/redisclient.h"
#include <QCommandLineParser>
#include <QJsonDocument>
#include <WinSock.h>
#include "Model/orderObject.h"

class QtRedisClient : public QObject
{
    Q_OBJECT
public:

    static QtRedisClient& getInstance();

    /**
    *功能:初始化 Redis;方便后期判断 redis 连接是否成功;
    *参数:[无]
    *返回:true:能够成功连接，false:连接失败
    **/
    bool initQtRedisClient();

    /**
    *功能:向 Redis 中push订单及订单状态信息;
    *参数:[1]订单号; [2]订单状态;
    *返回:true:追加成功，false:追加失败
    **/
    bool pushOrder2Redis(const OrderObject* orderObj);

    /**
    *功能:查询订单是否已经存在 Redis中;
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool testOrderRedisExist(const QString& orderId);


private:
    QMutex m_mutex;
    QtRedisClient();
    QtRedisClient(QtRedisClient const&);
    QtRedisClient& operator=(QtRedisClient const&);
    RedisClient::ConnectionConfig m_RedisConnectCnf;
    RedisClient::Connection*  m_pRedisConnectOperat = nullptr;

    QString m_redisIp;
    QString m_redisPassword;


signals:

public slots:
};

#endif // QTREDISCLIENT_H
