#ifndef PMSORDERSDATA_H
#define PMSORDERSDATA_H

#include <QtSql/QSqlDatabase>
#include <QtSql/QSqlQuery>
#include <QtSql/QSqlError>
#include <QObject>
#include <QMutex>
#include "Model/orderObject.h"
#include <Model/couponsObject.h>
#include <Model/singleProductObject.h>
#include "preDefine.h"

class PmsOrdersData : public QObject
{
    Q_OBJECT
public:
    // explicit PmsOrdersData(QObject *parent = 0);

    static PmsOrdersData& getInstance();

    /**
    *功能:初始化数据库;方便后期判断 打开数据库是否成功;
    *参数:[无]
    *返回:true:能够成功打开数据库，false:不能够成功打开数据库
    **/
    bool initPmsOrdersData();

    /**
    *功能:根据OMS数据 转换成 POS上申请的 ServiceType ID 保存到 PMS 数据库中;
    *参数:[1]订单对象指针 [2]订单状态;
    *返回:int     ServiceType ID
    * 【index id:
    *   App-MOP[18-销售,19-退货]  KouBei-MOP[29-销售,30-退货]   App-MOD[9-销售,17-退货]  客诉单[12 (无退单)]   Wechat-MOD[27-销售, 28-退货 ]
    *   ELEME[11-销售, 16-退货]   ORS[21-实物-销售(实物无退货),  23-配送费-销售, 24-配送费-退货]    MOP自测[20-销售(无退单) ]  STC[25-未使用]  HM[14-已停用]
    * 】
    **/
    int  convertPosServiceTypeId(const OrderObject* orderObj, const int &OrderStatus);

    /**
    *功能:插入一条汇总单信息到PMS数据库中;
    *参数:[1]订单对象指针 [2]返回插入成功后的自增序号;
    *返回:true操作成功，false失败
    **/
    bool insertOrderData(OrderObject* orderObj, QString& pmsOrderRef);

    /**
    *功能:删除PMS数据库中的指定订单状态的订单数据;
    *参数:[1]订单对象指针;
    *返回:true操作成功，false失败
    **/
    bool deleteOrderData(OrderObject* orderObj);

    /**
    *功能:插入订单主商品列表信息到PMS数据库中;
    *参数:[1]订单商品列表指针, [2]订单ID, [3] 返回插入成功后的自增序号;
    *返回:true操作成功，false失败
    **/
    bool insertProductData(const QList<dishesObject*> proList, const QString& OrderId, QString& ProInIdRef);

    /**
    *功能:插入订单 券列表信息到PMS数据库中;
    *参数:[1]订单券列表指针,  [2]订单ID,  [3] 返回插入成功后的自增序号;
    *返回:true操作成功，false失败
    **/
    bool insertConponData(const QList<CouponsObject*> coupList, const QString& OrderId, QString& ProInIdRef);


    /**
    *功能:删除PMS数据库中的指定订单状态的商品数据;
    *参数:[1]订单对象指针;
    *返回:true操作成功，false失败
    **/
    bool deleteProductData(OrderObject* orderObj);

    /**
    *功能:插入主商品的配料信息列表到PMS数据库中;
    *参数:[1]订单对象指针 [2]返回插入成功后的自增序号;
    *返回:true操作成功，false失败
    **/
    bool insertSubProductData(const QList<dishesObject*> sub_products, const QString& MainProOptions, const QString& ProInIdRef, QString& SubProInIdRef);

    /**
    *功能: 根据订单ID 更新 数据库中 Order 订单状态信息;
    *参数:[1]订单对象
    *返回:true操作成功，false失败
    **/
    bool updateOrderStatus(OrderObject* orderObj, const int &OrderStatus , const QString &makeStatus);

    /**
    *功能:查询 订单号和 订单状态 是否存在PMS数据库中;
    *参数:[1]订单号 [2]订单状态
    *返回:true是，false否
    **/
    bool isOrderAndStatusExist(const QString& orderId, const int &OrderStatus, const QString& makeStatus, bool& pmsMakeStatusIsExistRet, int& arriveAheadFlag);

    /**
    *功能:查询订单是否存在PMS数据库;
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isOrderExist(const QString& orderId);

    bool queryValue(const QString& orderId, const QString& key, QString& error, QVariant &value);

private:
    QMutex m_mutex;
    PmsOrdersData();
    PmsOrdersData(PmsOrdersData const&);
    PmsOrdersData& operator=(PmsOrdersData const&);
    QSqlDatabase m_sqlDb;

    QString m_sqlDbIp;
    QString m_sqlDbPassword;
    QString m_puginInitUrl;  // PcsPlugin Configure File Login Url Part;

signals:

public slots:
};

#endif // PMSORDERSDATA_H
