#ifndef PMSGETSTORECONFIG_H
#define PMSGETSTORECONFIG_H

#include <QtSql/QSqlDatabase>
#include <QtSql/QSqlQuery>
#include <QtSql/QSqlError>
#include <QObject>
#include <QMutex>

class PmsGetStoreConfig : public QObject
{
    Q_OBJECT
public:
    // explicit PmsGetStoreConfig(QObject *parent = 0);
    static PmsGetStoreConfig& getInstance();

    /**
    *功能:初始化 Mysql 门店基本配置 数据库;方便后期判断 打开 Mysql 数据库是否成功;
    *参数:[无]
    *返回:true:能够成功打开数据库，false:不能够成功打开数据库
    **/
    bool initPmsStoreConfigDB();

    /**
    *功能:获取 Mysql 数据库中 门店配置信息;
    *参数:[1]当前店员 操作员ID
    *返回:true:获取门店配置数据成功,false:获取门店配置数据失败;
    **/
    bool GetStoreConfig(QString& storeId, QString& posId,
                        QString& cashierId,QString& cashierName,
                        QString& pmsMachineNo);

private:
    QMutex m_mutex;
    PmsGetStoreConfig();
    PmsGetStoreConfig(PmsGetStoreConfig const&);
    PmsGetStoreConfig& operator=(PmsGetStoreConfig const&);
    QSqlDatabase m_sqlDb;

    QString m_sqlDbIp;
    QString m_sqlDbPassword;

signals:

public slots:
};

#endif // PMSGETSTORECONFIG_H
