#include "pmsGetStoreConfig.h"
#include "QsLog.h"
#include "DTools/configManger.h"

PmsGetStoreConfig::PmsGetStoreConfig()
{
    QLOG_INFO()<<"[<<<<---PmsGetStoreConfig:: ConStructure PMS Get Store Config DataBase--->>>>]";
}

bool PmsGetStoreConfig::initPmsStoreConfigDB() {
    bool bRet = false;
    if ( m_sqlDb.connectionName() != "PmsGetStoreConfig" ) {
        m_sqlDb = QSqlDatabase::addDatabase("QMYSQL","PmsGetStoreConfig");   //数据库驱动类型为Mysql
    }

    if(m_sqlDb.isValid()){
        QLOG_INFO()<<"[<<<<---PmsGetStoreConfig driver is valid--->>>>]";

        m_sqlDbIp = ConfigManger::GetInstance().GetMysqlIpConfig();
        m_sqlDbPassword = ConfigManger::GetInstance().GetMysqlPasswordConfig();

        m_sqlDb.setHostName( m_sqlDbIp.length() ? m_sqlDbIp :"127.0.0.1");      //连接数据库主机名，这里需要注意（若填的为”127.0.0.1“，出现不能连接，则改为localhost)
        m_sqlDb.setPort(3306);                 //连接数据库端口号，与设置一致
        m_sqlDb.setDatabaseName("pms");     //连接数据库名，与设置一致
        m_sqlDb.setUserName("oms");           //数据库用户名，与设置一致
        m_sqlDb.setPassword(m_sqlDbPassword.length() ? m_sqlDbPassword :"starbucks@oms");

        if(!m_sqlDb.open()) {                                      //打开数据库
            QLOG_ERROR()<<"[<<<<---PmsGetStoreConfig Open Database error:--->>>>]"<<m_sqlDb.lastError().text();
        } else {
            QLOG_INFO()<<"[<<<<---PmsGetStoreConfig Test Open database success!:--->>>>]";
            bRet = true;
            m_sqlDb.close();
        }
    } else {
        QLOG_ERROR()<<"[<<<<---PmsGetStoreConfig driver no valid--->>>>]";
    }
    return bRet;
}

PmsGetStoreConfig &PmsGetStoreConfig::getInstance() {
    static PmsGetStoreConfig pmsGetStoreConfig;
    return pmsGetStoreConfig;
}

bool PmsGetStoreConfig::GetStoreConfig(QString& storeId, QString& posId,
                                       QString& cashierId,QString& cashierName,
                                       QString& pmsMachineNo) {
    QMutexLocker mutex(&m_mutex);
    int bSelectRetNum = 0;
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---PmsGetStoreConfig::GetStoreConfig Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
    }else {
        QSqlQuery query(m_sqlDb);
        //读取门店编号;
        query.prepare(QString("select value from store_param where name = 'store_id' "));
        if(!query.exec()) {
            QLOG_ERROR()<<"[<<<<---PmsGetStoreConfig::Get store_id Select Failed--->>>>]"<<query.lastError().text();
        }else if (query.first()) {
            storeId = query.value(0).toString();
            bSelectRetNum++;
        }
        //读取PMS 插件编号;
        query.prepare(QString("select value from store_param where name = 'pms_plugin_no' "));
        if(!query.exec()) {
            QLOG_ERROR()<<"[<<<<---PmsGetStoreConfig::Get pms_plugin_no Select Failed--->>>>]"<<query.lastError().text();
        }else if (query.first()) {
            posId = query.value(0).toString();
            bSelectRetNum++;
        }
        //读取PMS 收银员ID;
        query.prepare(QString("select value from store_param where name = 'casher_id' "));
        if(!query.exec()) {
            QLOG_ERROR()<<"[<<<<---PmsGetStoreConfig::Get casher_id Select Failed--->>>>]"<<query.lastError().text();
        } else if (query.first()) {
            cashierId = query.value(0).toString();
            bSelectRetNum++;
        }
        //读取PMS 收银员名字;
        query.prepare(QString("select value from store_param where name = 'cashier_name' "));
        if(!query.exec()) {
            QLOG_ERROR()<<"[<<<<---PmsGetStoreConfig::Get cashier_name Select Failed--->>>>]"<<query.lastError().text();
        } else if (query.first()) {
            cashierName = query.value(0).toString();
            bSelectRetNum++;
        }
        //读取PMS 机器编号;
        query.prepare(QString("select value from store_param where name = 'pms_id' "));
        if(!query.exec()) {
            QLOG_ERROR()<<"[<<<<---PmsGetStoreConfig::Get pms_id Select Failed--->>>>]"<<query.lastError().text();
        }else if (query.first()) {
            pmsMachineNo = query.value(0).toString();
            bSelectRetNum++;
        }

        QLOG_INFO()<<QString("[<<<<---PmsGetStoreConfig::GetStoreConfig storeId:%1,posId:%2,cashierId:%3,cashierName:%4,pmsMachineNo:%5--->>>>]")
                     .arg(storeId).arg(posId).arg(cashierId).arg(cashierName).arg(pmsMachineNo);
        m_sqlDb.close();
    }
    //判断上面 5 个配置数据是否查询成功;
    if (5 == bSelectRetNum) {
        return true;
    } else {
        return false;
    }
}
