﻿#ifndef GETCABOXAREAUTH_H
#define GETCABOXAREAUTH_H
#include <QtSql/QSqlDatabase>
#include <QtSql/QSqlQuery>
#include <QtSql/QSqlError>
#include <QObject>
#include <QMutex>

class GetCaboxAReAuth : public QObject
{
    Q_OBJECT
public:
    // explicit GetCaboxAReAuth(QObject *parent = 0);
    static GetCaboxAReAuth& getInstance();

    /**
    *功能:初始化pos本地数据库;方便后期判断 打开pos本地数据库是否成功;
    *参数:[无]
    *返回:true:能够成功打开POS本地数据库，false:不能够成功打开POS本地数据库
    **/
    bool initGetAuthPosDB();

    /**
    *功能:查询本地的POS系统中当前用户是否已经绑定钱箱;
    *参数:[1]当前店员 操作员ID
    *返回:1:已经绑定钱箱，0:没有绑定钱箱
    **/
    int getUserHasCashBox(const QString& operatorId);

    /**
    *功能:查询本地的POS系统中当前用户是否拥有 经理 或 管理员权限;
    *参数:[1]当前店员 操作员ID
    *返回:1:是经理权限或是管理员，0:既没有经理权限也没有管理员权限
    **/
    int getUserRefundAuth(const QString& operatorId);

private:
    QMutex m_mutex;
    GetCaboxAReAuth();
    GetCaboxAReAuth(GetCaboxAReAuth const&);
    GetCaboxAReAuth& operator=(GetCaboxAReAuth const&);
    QSqlDatabase m_sqlDb;

signals:

public slots:
};

#endif // GETCABOXAREAUTH_H
