﻿#include "dataManger.h"
#include "preDefine.h"
#include <QJsonArray>

// 请求类型
enum
{
    LOGIN = 10, PULL_ORDER, CONFIRM_ORDER,
    REFUSE_ORDER,COMPLETE_ORDER = 16,
    REFUSE_REFUND = 18,SEND_ORDER = 19,
    REFUND_ORDER = 20, GET_DELIVER=21,
    REPORT_BILL_RESULT = 23,
    PULL_DISHES = 24, UPD_DISHES_STATUS = 25,DAY_REPORT =26,
    GET_STORE_CHANNEL_INFO = 28,SET_STORE_OPERATING_STATUS = 29,
    UPDATE_STOCK=80
};

DataManger &DataManger::GetInstance()
{
    static DataManger dm;
    return dm;
}

void DataManger::SetToken(const QString &token)
{
    m_token = token;
}

void DataManger::SetStoreId(const QString &storeId)
{
    m_storeId = storeId;
}

void DataManger::SetPosIpAddress(const QString &posIpAddress)
{
    m_posIpAddress = posIpAddress;
}


void DataManger::SetPartnerId(const QString &partnerId)
{
    m_partnerId=partnerId;
}

QJsonObject DataManger::GetLoginData(const QString& partnerId,const QString& storeId, const QString& password,
                             const QString& stationId, const QString& versionComments,const QString& ipAddress, QString& pmsMachineNo)
{
    QJsonObject rObj;
    rObj.insert(JSON_IPADDRESS, ipAddress);
    rObj.insert(JSON_PARTNERID,partnerId);
    rObj.insert(JSON_ORGCODE, storeId);
    rObj.insert(JSON_PASSWORD, password);
    rObj.insert(JSON_MACHINECODE, stationId);
    rObj.insert(JSON_PLUGINVERSION, APP_VERSION);
    rObj.insert(JSON_PLUGINVERSIONCOMMENTS, versionComments);
    rObj.insert(JSON_PMSMACHINENO, pmsMachineNo);
    return rObj;
}

QJsonObject DataManger::GetHeartData(const QString &password,const QString &stationId,
                                     const QString &ipAddress, const QString &versionComments,
                                     const bool lastHeartIsError,const QString &pmsMachineNo)
{
    QJsonObject rObj;
    rObj.insert(JSON_IPADDRESS, ipAddress);
    rObj.insert(JSON_PARTNERID,m_partnerId);
    rObj.insert(JSON_ORGCODE, m_storeId);
    rObj.insert(JSON_PASSWORD, password);
    rObj.insert(JSON_MACHINECODE, stationId);
    rObj.insert(JSON_PLUGINVERSION, APP_VERSION);
    rObj.insert(JSON_PLUGINVERSIONCOMMENTS, versionComments);
    rObj.insert(JSON_PMSMACHINENO, pmsMachineNo);
    if(lastHeartIsError){
        rObj.insert(JSON_SYNCSTORESTATUS, 1);
    }else{
        rObj.insert(JSON_SYNCSTORESTATUS, 0);
    }
    return rObj;
}

QJsonObject DataManger::GetPullOrderListData(const int& pageNumber, const int& pageSize, const QString&  pmsMachineNo)
{
    QJsonObject rObj;
    rObj.insert(JSON_PAGENUMBER,pageNumber);
    rObj.insert(JSON_PAGESIZE,pageSize);
    rObj.insert(JSON_SHOPCODE,m_storeId);
    rObj.insert(JSON_POSIPADDRESS,QString("http://") + m_posIpAddress);
    rObj.insert(JSON_CHANNEL,QString("ALL"));

    rObj.insert(JSON_PMSMACHINENO, pmsMachineNo);
    //rObj.insert(JSON_AUTOCONFIRM, autoconfirm);
    return rObj;
}

QJsonObject DataManger::GetPullDeliverData(const QString &storeId, const QString &channelCode)
{
    QJsonObject rObj;
    rObj.insert(JSON_REQTYPE, GET_DELIVER);
    rObj.insert(JSON_STOREID, storeId);
    rObj.insert(JSON_CHANNEL, channelCode);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetConfirmOrderData(const QString &orderId, const QString &channel)
{
    QJsonObject rObj;
    rObj.insert(JSON_BUSINESSID, orderId);
    rObj.insert(JSON_CHANNEL, channel);
    rObj.insert(JSON_SHOPCODE, m_storeId);
    rObj.insert(JSON_POSIPADDRESS,QString("http://") + m_posIpAddress);
    return rObj;
}

QJsonObject DataManger::GetRefuseOrderData(int refuseCode, const QString &orderId)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, REFUSE_ORDER);
    cObj.insert(JSON_ORDERID, orderId);
    cObj.insert(JSON_REASONCODE, refuseCode);
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    rObj.insert(JSON_POSIPADDRESS,QString("http://") + m_posIpAddress);
    return rObj;
}

QJsonObject DataManger::GetSendOrderData(const QString &orderId)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, SEND_ORDER);
    cObj.insert(JSON_ORDERID, orderId);
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetCompleteOrderData(const QString &orderId)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, COMPLETE_ORDER);
    cObj.insert(JSON_ORDERID, orderId);
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetRefundOrderData(int reasonCode,const QString &reason, const QString &orderId,const QString& channel,const QString& dishesListString, const QString& cashierId, const QString& cashierName)
{
    QJsonObject rObj;
    Q_UNUSED(channel);
    Q_UNUSED(reason);
    QJsonArray productIds;
    QString str = dishesListString;
    if(str.length()){
        QStringList list1 = str.split(";");
        for(int i=0;i<list1.size();++i){
            productIds.append(list1.at(i));
        }
    }
    rObj.insert(JSON_ORDERID, orderId);
    rObj.insert("productIds", productIds);
    rObj.insert("canceledCause", QString::number(reasonCode, 10) );
    rObj.insert("cashierNumber", cashierId);
    rObj.insert("cashierName", cashierName);
    rObj.insert(JSON_POSIPADDRESS,QString("http://") + m_posIpAddress);
    return rObj;
}

QJsonObject DataManger::GetRefuseRefundData(const QString &reason, const QString &orderId)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, REFUSE_REFUND);
    cObj.insert(JSON_ORDERID, orderId);
    cObj.insert(JSON_REASON, reason);
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetUpdDishesData(QMap<QString, int> dishesMap)
{
    QJsonObject rObj;
    QJsonArray dishes;
    QMap<QString, int>::iterator it;
    for(it = dishesMap.begin();  it!=dishesMap.end();  it++)
    {
        QJsonObject cObj;
        cObj.insert("code", it.key());
        cObj.insert("status", it.value());
        dishes.append(cObj);
    }

    rObj.insert(JSON_REQTYPE, UPD_DISHES_STATUS);
    rObj.insert("dishes", dishes);
    rObj.insert(JSON_TOKEN, m_token);
    return rObj;
}

QJsonObject DataManger::GetPullDishesData(const QString& channelCode)
{
    QJsonObject rObj;
    rObj.insert(JSON_REQTYPE, PULL_DISHES);
    rObj.insert(JSON_CHANNEL, channelCode);
    rObj.insert(JSON_TOKEN, m_token);
    return rObj;
}

QJsonObject DataManger::GetUpdDishesData(QString channelCode, QMap<QString, int> dishesMap)
{
    QJsonObject rObj;
    QJsonArray dishes;
    QMap<QString, int>::iterator it;
    for(it = dishesMap.begin();  it!=dishesMap.end();  it++)
    {
        QJsonObject cObj;
        cObj.insert("code", it.key());
        cObj.insert("status", it.value());
        dishes.append(cObj);
    }

    rObj.insert(JSON_REQTYPE, UPD_DISHES_STATUS);
    rObj.insert(JSON_CHANNEL, channelCode);
    rObj.insert("dishes", dishes);
    rObj.insert(JSON_TOKEN, m_token);
    return rObj;
}

QJsonObject DataManger::GetStoreChannelInfoData()
{
    QJsonObject rObj;
    rObj.insert(JSON_PARTNERID,m_partnerId);
    rObj.insert("OrganizationCode",m_storeId);
    return rObj;
}

QJsonObject DataManger::GetOperatingStatusData(const QString &channel, int status)
{
    QJsonObject rObj,cObj;
    QJsonArray array;
    rObj.insert(JSON_PARTNERID,m_partnerId);
    rObj.insert("OrganizationCode",m_storeId);
    cObj.insert(JSON_CHANNEL, channel);
    cObj.insert("state", status);
    array.append(cObj);
    rObj.insert("channel",array);
    return rObj;
}

QJsonObject DataManger::GetDayReportData(const QString &business)
{
    QJsonObject rObj;
    rObj.insert(JSON_REQTYPE,DAY_REPORT);
    rObj.insert(JSON_TOKEN,m_token);
    rObj.insert(JSON_BUSINESSDATE,business);
    return rObj;
}

QJsonObject DataManger::GetSelfCheckReqData()
{
    QJsonObject rObj;
    rObj.insert(JSON_IPADDRESS,m_posIpAddress);
    rObj.insert(JSON_MACHINECODE,"111111111111111");
    rObj.insert(JSON_STOREID,m_storeId);
    rObj.insert(JSON_PARTNERID,m_partnerId);
    rObj.insert(JSON_PASSWORD,"posoperator@freemud.cn");
    return rObj;
}
