﻿#ifndef CONFIGMANGER_H
#define CONFIGMANGER_H

#include <QSettings>
#include <QUrl>
#include <QPoint>

class ConfigManger
{
public:
    // 数据库连接信息
    typedef struct
    {
        QString host;
        QString username;
        QString password;
        QString database;
        int port;
    }SqlConnectInfo;

public:
    void GetStoreInfo(QString& storeId, QString &password);
    static ConfigManger& GetInstance();

    /* 功能:获取数据库连接信息
     * 参数:NULL
     * 返回:连接信息
     * */
    SqlConnectInfo GetSqlConnectInfo();
    /* 功能:设置数据库连接信息
     * 参数:连接信息
     * 返回:NULL
     * */
    void SetSqlConnectInfo(const SqlConnectInfo& info);
    /* 功能:读取登入服务器地址
     * 参数:NULL
     * 返回:服务器地址
     * */
    QString GetLoginServerUrl();
    /* 功能:读取订单服务器地址
     * 参数:NULL
     * 返回:服务器地址
     * */
    QString GetOrderServerUrl();
    /* 功能:读取门店服务器地址
     * 参数:NULL
     * 返回:服务器地址
     * */
    QString GetStoreServerUrl();
    /* 功能:读取接口名称
     * 参数:NULL
     * 返回:服务器地址
     * */
    QString GetInterfaceName(const QString& name);
    /* 功能:读取打印机名称
     * 参数:NULL
     * 返回:服务器地址
     * */
    QString GetPrinterName();
    /* 功能:设置打印机名称
     * 参数:打印机名称
     * 返回:NULL
     * */
    void SetPrinterName(const QString& printer);
    /* 功能:读取悬浮窗坐标
     * 参数:NULL
     * 返回:服务器地址
     * */
    QPoint GetFloatInitPostion();
    /* 功能:设置悬浮窗坐标
     * 参数:NULL
     * 返回:服务器地址
     * */
    void setFloatInitPostion(const QPoint& postion);
    /* 功能:获取悬浮窗闪烁间隔时长
     * 参数:NULL
     * 返回:间隔时长
     * */
    int GetBlinkInterval();
    /* 功能:获取播放声音间隔时长
     * 参数:NULL
     * 返回:间隔时长
     * */
    int GetSoundInterval();
    /* 功能:获取是否存在[重新补单]
     * 参数:NULL
     * 返回:true存在false不存在
     * */
    bool GetIsExistReEntryOrder();
    /* 功能:获取TCP监听端口
     * 参数:NULL
     * 返回:端口号
     * */
    int GetTcpServerPort();
    /* 功能:获取销售单写入地址
     * 参数:NULL
     * 返回:销售单地址
     * */
    QString GetDbServerIp();
    /* 功能:获取销售单写入端口
     * 参数:NULL
     * 返回:销售单端口
     * */
    int GetDbServerPort();
    int GetAutoconfirm();

    /* 功能:获取HttpServer监听端口
     * 参数:NULL
     * 返回:销售单端口
     * */
    int GetHttpServerPort();

    /* 功能:获取 开通 TCP Channel Config
     * 参数:NULL
     * 返回: true: 开通;   false:关闭;
     * */
    bool GetOpenTcpChannel();

    /* 功能:获取商户号
     * 参数:NULL
     * 返回:前缀
     * */
    QString GetPartnerId();

    /* 功能:获取同步库存的间隔
     * 参数:NULL
     * 返回:前缀
     * */
    int GetUpdDishesInterval();

    int GetPushServerPort();

    QString GetIpAddress();

    QPoint GetOMSBtnPostion();
    // 获取Simphony 为OMS所做button 相对系统屏幕最右下角的偏移位置;
    int GetOMSBtnWidthOffset();
    int GetOMSBtnHeightOffset();

    int GetLoginSslConfig();
    int GetOrderSslConfig();

    // Get Mysql IP & Password Config;
    QString GetMysqlIpConfig();
    QString GetMysqlPasswordConfig();

    // Get Redis IP & Password Config;
    QString GetRedisIpConfig();
    QString GetRedisPasswordConfig();


private:
    ConfigManger();
    ConfigManger(ConfigManger const&);
    ConfigManger& operator=(ConfigManger const&);

private:
    // 程序配置和用户配置
    QSettings *m_config;
    QSettings *m_userConfig;
};

#endif // CONFIGMANGER_H
