﻿#include "configManger.h"
#include <QSqlDatabase>
#include <QApplication>
#include <QSqlError>
#include "preDefine.h"

void ConfigManger::GetStoreInfo(QString &storeId,/* QString &posNo,QString &cashierId,*/QString &password)
{
    storeId=m_config->value(INI_STOREID).toString();
    //posNo=m_config->value(INI_POSNO).toString();
    //cashierId="001";
    password=m_config->value(INI_PASSWORD).toString();
}

ConfigManger &ConfigManger::GetInstance()
{
    static ConfigManger cm;
    return cm;
}

ConfigManger::ConfigManger()
{
    QString appDir = QApplication::applicationDirPath();
    QString config = QString("%1/%2").arg(appDir).arg(CONFIG_NAME);
    QString userConfig = QString("%1/%2").arg(appDir).arg(USERCONFIG_NAME);
    m_config = new QSettings(config, QSettings::IniFormat);
    m_userConfig = new QSettings(userConfig, QSettings::IniFormat);
}

ConfigManger::SqlConnectInfo ConfigManger::GetSqlConnectInfo()
{
    SqlConnectInfo info;
    info.host = m_userConfig->value(INI_DB_HOST).toString();
    info.username = m_userConfig->value(INI_DB_USERNAME).toString();
    info.password = m_userConfig->value(INI_DB_PASSWORD).toString();
    info.database = m_userConfig->value(INI_DB_DATABASE).toString();
    info.port = m_userConfig->value(INI_DB_PORT).toInt();
    return info;
}

void ConfigManger::SetSqlConnectInfo(const ConfigManger::SqlConnectInfo &info)
{
    m_userConfig->setValue(INI_DB_HOST, info.host);
    m_userConfig->setValue(INI_DB_USERNAME, info.username);
    m_userConfig->setValue(INI_DB_PASSWORD, info.password);
    m_userConfig->setValue(INI_DB_DATABASE, info.database);
}

QString ConfigManger::GetLoginServerUrl()
{
    return m_config->value(INI_LOGINSERVER).toString();
}
QString ConfigManger::GetOrderServerUrl()
{
    return m_config->value(INI_ORDERSERVER).toString();
}
QString ConfigManger::GetStoreServerUrl()
{
    return m_config->value(INI_STORESERVER).toString();
}

QString ConfigManger::GetInterfaceName(const QString &name)
{
    return m_config->value(QString("Interface/")+name).toString();
}

QString ConfigManger::GetPrinterName()
{
    return m_userConfig->value(INI_PRINTERNAME).toString();
}

void ConfigManger::SetPrinterName(const QString &printer)
{
    m_userConfig->setValue(INI_PRINTERNAME, printer);
}

QPoint ConfigManger::GetFloatInitPostion()
{
    return m_userConfig->value(INI_FLOATPOSTION, QPoint(20, 20)).toPoint();
}

void ConfigManger::setFloatInitPostion(const QPoint &postion)
{
    m_userConfig->setValue(INI_FLOATPOSTION, postion);
}

int ConfigManger::GetBlinkInterval()
{
    return m_userConfig->value(INI_BLINKINTERVAL).toFloat()*1000*2;
}

int ConfigManger::GetSoundInterval()
{
    return m_userConfig->value(INI_SOUNDINTERVAL).toFloat()*1000;
}

bool ConfigManger::GetIsExistReEntryOrder()
{
    return m_config->value(INI_REENTRY, 0).toBool();
}

int ConfigManger::GetTcpServerPort()
{
    return m_config->value(INI_TCPPORT, 93953).toInt();
}

QString ConfigManger::GetDbServerIp()
{
    return m_config->value(INI_DBSERVERIP).toString();
}

int ConfigManger::GetDbServerPort()
{
    return m_config->value(INI_DBSERVERPORT).toInt();
}

int ConfigManger::GetAutoconfirm()
{
    return m_config->value(INI_AUTOCONFIRM).toInt();
}

int ConfigManger::GetHttpServerPort()
{
    return m_config->value(INI_HTTPSERVERPORT, 80).toInt();
}

bool ConfigManger::GetOpenTcpChannel()
{
    return m_config->value(INI_OPEN_TCP_CHANNEL, false).toBool();
}

QString ConfigManger::GetPartnerId()
{
    return m_config->value(INI_PARTNERID).toString();
}

int ConfigManger::GetUpdDishesInterval()
{
    return m_config->value(INI_INTERVAL).toInt();
}

int ConfigManger::GetPushServerPort()
{
    return m_config->value(INI_PUSHSERVERPORT,24409).toInt();
}

QString ConfigManger::GetIpAddress()
{
    return m_config->value("IpAddress/ip").toString();
}

QPoint ConfigManger::GetOMSBtnPostion()
{
    return m_userConfig->value(INI_OMSBTNPOSTION).toPoint();
}

int ConfigManger::GetOMSBtnWidthOffset()
{
    return m_userConfig->value(INI_OMSBTNWIDTHOFFSET).toInt();
}

int ConfigManger::GetOMSBtnHeightOffset()
{
    return m_userConfig->value(INI_OMSBTNHEIGHTOFFSET).toInt();
}


int ConfigManger::GetLoginSslConfig()
{
    return m_config->value("SSLConfig/login").toInt();
}

QString ConfigManger::GetMysqlIpConfig()
{
    return m_config->value("MysqlConfig/ip").toString();
}

QString ConfigManger::GetMysqlPasswordConfig()
{
    return m_config->value("MysqlConfig/password").toString();
}

QString ConfigManger::GetRedisIpConfig()
{
    return m_config->value("RedisConfig/ip").toString();
}

QString ConfigManger::GetRedisPasswordConfig()
{
    return m_config->value("RedisConfig/password").toString();
}


int ConfigManger::GetOrderSslConfig()
{
    return m_config->value("SSLConfig/order").toInt();
}



