#include "stdafx.h"
#include "FECLabPrint.h"


string SetSize(string m, string n)
{
	string command;
	command.append("SIZE ");
	command.append(m);
	command.append(" mm,");
	command.append(n);
	command.append(" mm");
	command.append("\r\n");
	return command;
}
string SetCashDrawer(double m)
{
	string command;
	return command;
}
string SetGap(double m, double n)
{
	string command;
	command.append("GAP ");
	command.append(std::to_string(long double(m)));
	command.append(" mm,");
	command.append(std::to_string(long double(n)));
	command.append(" mm");
	command.append("\r\n");
	return command;
}
string SetOffset(double m)
{
	string command;
	command.append("OFFSET ");
	command.append(std::to_string(long double(m)));
	command.append(" mm");
	command.append("\r\n");
	return command;
}
string SetSpeed(string n)
{
	string command;
	command.append("SPEED ");
	command.append(n);
	command.append("\r\n");
	return command;
}
string SetDensity(string n)
{
	string command;
	command.append("DENSITY ");
	command.append(n);
	command.append("\r\n");
	return command;
}
string SetDirection(double n)
{
	string command;
	command.append("DIRECTION ");
	command.append(std::to_string(long long(n)));
	command.append("\r\n");
	return command;
}
string SetReference(int x, int y)
{
	string command;
	command.append("REFERENCE ");
	command.append(std::to_string(long long(x)));
	command.append(",");
	command.append(std::to_string(long long(y)));
	command.append("\r\n");
	return command;
}
string SetShift(int n)
{
	string command;
	command.append("SHIFT ");
	command.append(std::to_string(long long(n)));
	command.append("\r\n");
	return command;
}
string SetCodePage(int n)
{
	string command;
	command.append("CODEPAGE ");
	command.append(std::to_string(long long(n)));
	command.append("\r\n");
	return command;
}
string SetCls()
{
	string command;
	command.append("CLS ");
	command.append("\r\n");
	return command;
}
string SetFeed(int n)
{
	string command;
	command.append("FEED ");
	command.append(std::to_string(long long(n)));
	command.append("\r\n");
	return command;
}
string SetBackFeedAndBackup(int n)
{
	string command;
	command.append("BACKUP ");
	command.append(std::to_string(long long(n)));
	command.append("\r\n");
	return command;
}
string SetFormFeed()
{
	string command;
	command.append("FORMFEED ");
	command.append("\r\n");
	return command;
}
string SetHome()
{
	string command;
	command.append("HOME ");
	command.append("\r\n");
	return command;
}
string SetSound(int level, int doubleerval)
{
	string command;
	command.append("SOUND ");
	command.append(std::to_string(long long(level)));
	command.append(",");
	command.append(std::to_string(long long(doubleerval)));
	command.append("\r\n");
	return command;
}
string SetLimitFeed(double n)
{
	string command;
	command.append("LIMITFEED ");
	command.append(std::to_string(long double(n)));
	command.append("\r\n");
	return command;
}
string SetSelftest()
{
	string command;
	command.append("SELFTEST ");
	command.append("\r\n");
	return command;
}
string PrintBuffer(char* m, char* n)
{
	string command;
	command.append("PRINT ");
	command.append("1");
	command.append(",");
	command.append("1");
	command.append("\r\n");
	return command;
}

// ָ
string PrintBar(int x, int y, int width, int height)
{
	string command;
	command.append("BAR ");
	command.append(std::to_string(long long(x)));
	command.append(",");
	command.append(std::to_string(long long(y)));
	command.append(",");
	command.append(std::to_string(long long(width)));
	command.append(",");
	command.append(std::to_string(long long(height)));
	command.append("\r\n");
	return command;
}
string PrintBarcode(int x, int y, char* codeType, int height,int humanReadable,
				int rotation, int narrow, int wide, char* code)
{
	string command;
	command.append("BARCODE ");
	command.append(std::to_string(long long(x)));
	command.append(",");
	command.append(std::to_string(long long(y)));
	command.append(",\"");
	command.append(codeType);
	command.append("\",");
	command.append(std::to_string(long long(height)));
	command.append(",");
	command.append(std::to_string(long long(humanReadable)));
	command.append(",");
	command.append(std::to_string(long long(rotation)));
	command.append(",");
	command.append(std::to_string(long long(narrow)));
	command.append(",");
	command.append(std::to_string(long long(wide)));
	command.append(",\"");
	command.append(code);
	command.append("\"\r\n");
	return command;
}
string PrintBox(int xStart, int yStart, int xEnd, int yEnd, int lineThickness)
{
	string command;
	command.append("BOX ");
	command.append(std::to_string(long long(xStart)));
	command.append(",");
	command.append(std::to_string(long long(yStart)));
	command.append(",");
	command.append(std::to_string(long long(yStart)));
	command.append(",");
	command.append(std::to_string(long long(yStart)));
	command.append(",");
	command.append(std::to_string(long long(yStart)));
	command.append("\r\n");
	return command;
}
string PrintBitmap(int x, int y, int width, int height, int mode, int bitMapData)
{
	string command;
	command.append("BITMAP ");
	command.append(std::to_string(long long(x)));
	command.append(",");
	command.append(std::to_string(long long(y)));
	command.append(",");
	command.append(std::to_string(long long(width)));
	command.append(",");
	command.append(std::to_string(long long(height)));
	command.append(",");
	command.append(std::to_string(long long(mode)));
	command.append(",");
	command.append(std::to_string(long long(bitMapData)));
	command.append("\r\n");
	return command;
}
string PrintPutBmp(int x, int y, char* fileName)
{
	string command;
	command.append("PUTBMP ");
	command.append(std::to_string(long long(x)));
	command.append(",");
	command.append(std::to_string(long long(y)));
	command.append(",\"");
	command.append(fileName);
	command.append("\"\r\n");
	return command;
}
string PrintPutPcx(int x, int y, char* fileName)
{
	string command;
		command.append("PUTPCX ");
	command.append(std::to_string(long long(x)));
	command.append(",");
	command.append(std::to_string(long long(y)));
	command.append(",\"");
	command.append(fileName);
	command.append("\"\r\n");
	return command;
}
string PrintErase(int xStart, int yStart, int xWidth, int yHeight)
{
	string command;
	command.append("ERASE ");
	command.append(std::to_string(long long(xStart)));
	command.append(",");
	command.append(std::to_string(long long(yStart)));
	command.append(",");
	command.append(std::to_string(long long(xWidth)));
	command.append(",");
	command.append(std::to_string(long long(yHeight)));
	command.append("\r\n");
	return command;
}
string PrintReverse(int xStart, int yStart, int xWidth, int yHeight)
{
	string command;
	command.append("REVERSE ");
	command.append(std::to_string(long long(xStart)));
	command.append(",");
	command.append(std::to_string(long long(yStart)));
	command.append(",");
	command.append(std::to_string(long long(xWidth)));
	command.append(",");
	command.append(std::to_string(long long(yHeight)));
	command.append("\r\n");
	return command;
}
string PrintText(int x,int y, const char* font, int rotation, int xMulitiplication, int yMulitiplication, const char* content)
{
	string command;
	command.append("TEXT ");
	command.append(std::to_string(long long(x)));
	command.append(",");
	command.append(std::to_string(long long(y)));
	command.append(",\"");
	command.append(font);
	command.append("\",");
	command.append(std::to_string(long long(rotation)));
	command.append(",");
	command.append(std::to_string(long long(xMulitiplication)));
	command.append(",");
	command.append(std::to_string(long long(yMulitiplication)));
	command.append(",\"");
	command.append(content);
	command.append("\"\n");
	return command;
}
