#pragma once

#define COM				1
#define PARALLEL		2
#define EMAC			3
#define USB				4
#define PORTOPEN        1
#define PORTCLOSE       0



typedef struct{
	int bandRate;
	int dataBits;
	int parity;
	int stopBits;
	int param;
	string comName;
} ComSettings;

class ComControl
{
public:
	ComControl(void);
	~ComControl(void);
	void SetComType(int type);
	void SetComSettings(const string& comName, int bandRate, int dataBits, int parity, int stopBits, int param);
	bool OpenCom(string& error);
	void sendCommand(string command);
	void CloseCom();

private:
	int _portState;
	int _comType;
	HANDLE _hCom;
	ComSettings _comSettings;
};

