#include "stdAfx.h"
#include "ComControl.h"


ComControl::ComControl(void):_comType(0),_hCom(NULL),_portState(0)
{
}


ComControl::~ComControl(void)
{
}

void ComControl::SetComType(int type)
{
	_comType = type;
}

void ComControl::SetComSettings(const string& comName, int bandRate, int dataBits, int parity, int stopBits, int param)
{
	//comName[] size =96
	_comSettings.comName = comName;
	_comSettings.bandRate = bandRate;
	_comSettings.dataBits = dataBits;
	_comSettings.parity   = parity;
	_comSettings.stopBits = stopBits;
	_comSettings.param    = param;
}

bool ComControl::OpenCom(string& error)
{
	if(0 == _comType)
	{
		error = string("˿ڴʧܣö˿");
		_portState = 0;
		return false;
	}
	DWORD dwError;
	_hCom = CreateFile(_comSettings.comName.data(), GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
	if ((HANDLE)0xFFFFFFFF == _hCom)
	{
		dwError = GetLastError();
		error.append("˿ڴʧܣ");
		error.append(std::to_string(_ULonglong(dwError)));
		_portState = 0;
		return false;
	}
	_portState = 1;
	COMMTIMEOUTS TimeOuts;
	//趨ʱ
	TimeOuts.ReadIntervalTimeout = MAXDWORD;
	TimeOuts.ReadTotalTimeoutMultiplier = 0;
	TimeOuts.ReadTotalTimeoutConstant = 0;
  	//趨дʱ
	TimeOuts.WriteTotalTimeoutMultiplier = 100;
	TimeOuts.WriteTotalTimeoutConstant = 500;
	SetCommTimeouts(_hCom,&TimeOuts); //óʱ
	SetupComm(_hCom,1024,1024); //뻺ĴС1024
	//DCB wdcb;
	//GetCommState(_hCom, &wdcb);
	//wdcb.BaudRate = 9600;//ʣ9600
	//wdcb.ByteSize = 8;   //ÿֽ8λ
	//wdcb.Parity = NOPARITY;  //ֹͣλ
	//SetCommState(_hCom, &wdcb);
	PurgeComm(_hCom,PURGE_TXCLEAR|PURGE_RXCLEAR);

	return true;
}

void ComControl::sendCommand(string command)
{
	DWORD length = 0;
	
	WriteFile(_hCom,command.data(),command.size(),&length,NULL);
	cout<<command.data()<<command.size()<<length;
}

void ComControl::CloseCom()
{
	CloseHandle(_hCom);
}