#ifndef LOADDLL_H
#define LOADDLL_H

#pragma once

#define POS_SUCCESS                     1001 // ִгɹ

#define POS_FAIL                        1002 // ִʧ

#define POS_ERROR_INVALID_HANDLE        1101 // ˿ڻļľЧ

#define POS_ERROR_INVALID_PARAMETER     1102 // Ч

#define POS_ERROR_NOT_BITMAP            1103 // λͼʽļ

#define POS_ERROR_NOT_MONO_BITMAP       1104 // λͼǵɫ

#define POS_ERROR_BEYONG_AREA           1105 // λͼӡ
											 // ĴС

#define POS_ERROR_INVALID_PATH          1106 // ûҵָļ
											 // ·

#define POS_COM_DTR_DSR 0x00 // ΪDTR/DST
  
#define POS_COM_RTS_CTS 0x01 // ΪRTS/CTS 

#define POS_COM_XON_XOFF 0x02 // ΪXON/OFF 

#define POS_COM_NO_HANDSHAKE 0x03 //  

#define POS_OPEN_PARALLEL_PORT 0x12 // 򿪲ͨѶ˿ 

#define POS_OPEN_BYUSB_PORT 0x13 // USBͨѶ˿ 

#define POS_OPEN_PRINTNAME 0X14 //򿪴ӡ

#define POS_OPEN_NETPORT 0X15 // ̫ӡ

#define POS_FONT_TYPE_STANDARD 0x00 // ׼ ASCII
 
#define POS_FONT_TYPE_COMPRESSED 0x01 // ѹ ASCII 
 
#define POS_FONT_TYPE_UDC 0x02 // ûԶַ
	
#define POS_FONT_TYPE_CHINESE 0x03 // ׼ 塱
 
#define POS_FONT_STYLE_NORMAL 0x00 // 
 
#define POS_FONT_STYLE_BOLD 0x08 // Ӵ
 
#define POS_FONT_STYLE_THIN_UNDERLINE 0x80 // 1ֵ»
 
#define POS_FONT_STYLE_THICK_UNDERLINE 0x100 // 2ֵ»
 
#define POS_FONT_STYLE_UPSIDEDOWN 0x200 // ãֻЧ
 
#define POS_FONT_STYLE_REVERSE 0x400 // ԣڵװ֣
 
#define POS_FONT_STYLE_SMOOTH 0x800 // ƽڷŴʱ
 
#define POS_FONT_STYLE_CLOCKWISE_90 0x1000 // ÿַ˳ʱת 90 

#define POS_PRINT_MODE_STANDARD 0x00 // ׼ģʽģʽ
 
#define POS_PRINT_MODE_PAGE 0x01 // ҳģʽ
 
#define POS_PRINT_MODE_BLACK_MARK_LABEL 0x02 // ڱǱǩģʽ

#define POS_BARCODE_TYPE_UPC_A 0x41 // UPC-A
 
#define POS_BARCODE_TYPE_UPC_E 0x42 // UPC-C
 
#define POS_BARCODE_TYPE_JAN13 0x43 // JAN13(EAN13)
 
#define POS_BARCODE_TYPE_JAN8 0x44 // JAN8(EAN8)
 
#define POS_BARCODE_TYPE_CODE39 0x45 // CODE39
 
#define POS_BARCODE_TYPE_ITF 0x46 // INTERLEAVED 2 OF 5
 
#define POS_BARCODE_TYPE_CODEBAR 0x47 // CODEBAR
 
#define POS_BARCODE_TYPE_CODE93 0x48 // 25
 
#define POS_BARCODE_TYPE_CODE128 0x49 // CODE 128
 
#define POS_FONT_TYPE_STANDARD 0x00 // ׼ASCII 
 
#define POS_FONT_TYPE_COMPRESSED 0x01 // ѹASCII
 
#define POS_HRI_POSITION_NONE 0x00 // ӡ
 
#define POS_HRI_POSITION_ABOVE 0x01 // ֻϷӡ
 
#define POS_HRI_POSITION_BELOW 0x02 // ֻ·ӡ
 
#define POS_HRI_POSITION_BOTH 0x03 // ϡ·ӡ
 
#define POS_BITMAP_PRINT_NORMAL 0x00 // 
 
#define POS_BITMAP_PRINT_DOUBLE_WIDTH 0x01 // 
 
#define POS_BITMAP_PRINT_DOUBLE_HEIGHT 0x02 // 
 
#define POS_BITMAP_PRINT_QUADRUPLE 0x03 // ұ
 
#define POS_CUT_MODE_FULL 0x00 // ȫ
 
#define POS_CUT_MODE_PARTIAL 0x01 // 
 
#define POS_AREA_LEFT_TO_RIGHT 0x0 // Ͻ
 
#define POS_AREA_BOTTOM_TO_TOP 0x1 // ½
 
#define POS_AREA_RIGHT_TO_LEFT 0x2 // ½
 
#define POS_AREA_TOP_TO_BOTTOM 0x3 // Ͻ

typedef struct 
{
	int x;
	int y;
	int font_size;
	int rotate;
	int font_type;
	int line;
	string font_name;
	string data;
} Function_Argv;

#define INIT_FUN_ARGV(tmpx, tmpheigth, tmpfont_size, tmpfont_type, tmpline, tmpfont_name, tmpdata) do {			\
	argv.x = tmpx;							\
	argv.y = tmpheigth;						\
	argv.font_size = tmpfont_size;			\
	argv.font_type = tmpfont_type;			\
	argv.line = tmpline;					\
	argv.font_name = string(tmpfont_name);	\
	argv.data = string(tmpdata);			\
}while(0);

/***************ͨú*****************/
typedef HANDLE (__stdcall *POS_Open)( LPCTSTR lpName, 
									  int nComBaudrate,
									  int nComDataBits, 
									  int nComStopBits, 
									  int nComParity, 
									  int nParam );

typedef int (__stdcall *POS_Close)(void);

typedef int (__stdcall *POS_Reset)(void);

typedef int (__stdcall *POS_SetMode)(int nPrintMode);

typedef int (__stdcall *POS_SetMotionUnit)(int nHorizontalMU,int nVerticalMU);

typedef int (__stdcall *POS_SetCharSetAndCodePage)(int nCharSet,int nCodePage);

typedef int (__stdcall *POS_FeedLine)(void);

typedef int (__stdcall *POS_SetLineSpacing)(int nDistance);

typedef int (__stdcall *POS_SetRightSpacing)(int nDistance);

typedef int (__stdcall *POS_PreDownloadBmpToRAM)(char *pszPath,int nID);

typedef int (__stdcall *POS_PreDownloadBmpsToFlash)(char *pszPaths[],int nCount);

typedef int (__stdcall *POS_QueryStatus)(char *pszStatus,int nTimeouts);

typedef int (__stdcall *POS_QueryStatusLPT)(HANDLE hPort, char *pStatus);

typedef int (__stdcall *POS_S_BarcodeQR)(
										 HANDLE hPort,
										 char *pszInfo,
										 int nOrgx,
										 int iWidth,
										 int iSymbolType,
										 int iLanguageMode,
										 int nBytesOfBuffer,
										 int iErrorCorrect
		                                 );

typedef int (__stdcall *POS_PL_BarcodeQR)(
										  HANDLE hPort,
										  char *pszInfo,
										  int nOrgx,
										  int nOrgy,
										  int iWidth,
										  int iSymbolType,
										  int iLanguageMode,
										  int nBytesOfBuffer,
										  int iErrorCorrect
		                                  );

typedef int (__stdcall *POS_S_BarcodePDF417)(
											 HANDLE hPort,
											 int nOrgx,
											 char *pszBuffer,
											 int nBytesOfBuffer,
											 int nWidth,
											 int nHeight,
											 int nLines,
											 int nColumns,
											 int nScaleH,
											 int nScaleV,
											 int nCorrectGrade
							                );
typedef int (__stdcall *POS_PL_BarcodePDF417)(
											  HANDLE hPort,
											  int nOrgx,
											  int nOrgy,
											  char *pszBuffer,
											  int nBytesOfBuffer,
											  int nWidth,
											  int nHeight,
											  int nLines,
											  int nColumns,
											  int nScaleH,
											  int nScaleV,
											  int nCorrectGrade
							                  );

typedef int (__stdcall *POS_RTQueryStatus)(char *pszStatus);

typedef int (__stdcall *POS_RTQueryStatusLPT)(	HANDLE hPort, char *pStatus );

typedef int (__stdcall *POS_NETQueryStatus)(char *ipAddress,char *pszStatus);

typedef int (__stdcall *POS_KickOutDrawer)(int nID,int nOnTimes,int nOffTimes);

typedef int (__stdcall *POS_CutPaper)(int nMode,int nDistance);

typedef bool (__stdcall *POS_StartDoc)();

typedef bool (__stdcall *POS_EndDoc)();

typedef bool (__stdcall *POS_EndSaveFile)();

typedef bool (__stdcall *POS_BeginSaveFile)(LPCTSTR lpFileName,bool bToPrinter);

/******ֱֻ֧׼ӡģʽ(ģʽ)ĺ******/
typedef int (__stdcall *POS_S_SetAreaWidth)(int nWidth);

typedef int (__stdcall *POS_S_TextOut)( char *pszString,			 
									    int nOrgx,									 
									    int nWidthTimes,									 
									    int nHeightTimes,									 
									    int nFontType,									 
									    int nFontStyle);

typedef int (__stdcall *POS_S_DownloadAndPrintBmp)(char *pszPath,int nOrgx,int nMode);

typedef int (__stdcall *POS_S_PrintBmpInRAM)(int nID,int nOrgx,int nMode);

typedef int (__stdcall *POS_S_PrintBmpInFlash)(int nID,int nOrgx,int nMode);

typedef int (__stdcall *POS_S_SetBarcode)( char *pszInfoBuffer,
										   int nOrgx,
										   int nType,
										   int nWidthX,
										   int nHeight,
										   int nHriFontType,
										   int nHriFontPosition,
										   int nBytesToPrint);

/****ֻ֧ҳӡģʽ(P)ǩӡģʽ(L)ĺ****/
typedef int (__stdcall *POS_PL_SetArea)( int nOrgx,
									     int nOrgy,
									     int nWidth,
									     int nHeight,
									     int nDirection);

typedef int (__stdcall *POS_PL_TextOut)( char *pszString,
										 int nOrgx,
										 int nOrgy,
										 int nWidthTimes,
										 int nHeightTimes,
										 int nFontType,
										 int nFontStyle);

typedef int (__stdcall *POS_PL_DownloadAndPrintBmp)(char *pszPath,int nOrgx,int nOrgy,int nMode);

typedef int (__stdcall *POS_PL_PrintBmpInRAM)(int nID,int nOrgx,int nOrgy,int nMode);

typedef int (__stdcall *POS_PL_SetBarcode)( char *pszInfoBuffer,
											int nOrgx,
											int nOrgy,
											int nType,
											int nWidthX,
											int nHeight,
											int nHriFontType,
											int nHriFontPosition,
											int nBytesToPrint);

typedef int (__stdcall *POS_PL_Print)(void);

typedef int (__stdcall *POS_PL_Clear)(void);



/********--ҪڵԺԶƺʹ*******/
typedef int (__stdcall *POS_WriteFile)(HANDLE hPort,char *pszData,int nBytesToWrite);

typedef int (__stdcall *POS_ReadFile)( HANDLE hPort,
									   char *pszData,
									   int nBytesToRead,
									   int nTimeouts);

typedef HANDLE (__stdcall *POS_SetHandle)(HANDLE hNewHandle);

typedef int (__stdcall *POS_GetVersionInfo)(int *pnMajor,int *pnMinor);

//****************־***********************//
typedef void (__stdcall *WriteLog)(unsigned char ,char *,...);

//-------------------------------TSC-------------------------------//
typedef int (__stdcall *openport)(char* printername);
typedef void (__stdcall *closeport)(void);
typedef int (__stdcall *about)(void);
typedef int (__stdcall *barcode)(char* x, char* y, char* type,
								 char* height, char* readable, char* rotation,
								 char* narrow, char* wide, char* code);
typedef int (__stdcall *clearbuffer)(void);
typedef int (__stdcall *downloadpcx)(char* filename, char* image_name);
typedef int  (__stdcall *formfeed)(void);
typedef int (__stdcall *nobackfeed)(void);
typedef int (__stdcall *printerfont)(char* x, char* y, char* fonttype,
									 char* rotation, char* xmul, char* ymul,
									 char* text);
typedef int (__stdcall *printlabel)(char* set, char* copy);
typedef int (__stdcall *sendcommand)(char* printercommand);
typedef int (__stdcall *setup)(char* width, char* height,
							   char* speed, char* density,
							   char* sensor, char* vertical,
							   char* offset);
typedef int (__stdcall *windowsfont)(int x, int y, int fontheight,
									 int rotation,  int fontstyle, int fontunderline,
                    char* szFaceName, char* content);

//----------------------------------end----------------------------------//

typedef struct
{
    string printname;//ӡ
    string m_parall; //
    string m_Usb;// usb
    string m_level; //־ļ趨 Ĭ
    string m_Ip ;
	string printtscname;//ǩӡ
    int m_PrintType;    //ӡĳʽ
    int m_PrintSize;    //ӡֽ趨
    int type;
	int m_nDays;
	string tsc_widgth;		//ǩӡĿ
	string tsc_high;		//ǩӡĸ߶
	string tsc_speed;		//ֽٶ
	string tsc_chroma;		//ӡŪ

} PrintClass,*pPrintclass;    
/****************غжض̬**************************/
bool _LoadPosdll(void);
bool _UnloadPosdll(void);
bool _UnloadLogdll(void);
/***************posڲú*****************/
void closeportpos(void);
void _StartDoc();
void _CloseDoc();
bool _ChoosePort();
void CommPort();
int getPrinttype();
void ParallelPort();
void UsbPort();
void NetPort();
void DriverPort();
void CheckStatus();
void _InPrintData(char data[]);
void GetProfilePath(char *CONFIGFILE);
void _GetPrintIni(char inidata[]);
bool _PrintLine(char data[], int fontType,int fontStyle ,int width,int height);//ӡ
bool _PrintBarCode(char data[],int type, int leftMargin,int fontType ,int width,int height,int position);//ӡ
bool _PrintQRCode(char data[], int type,  int leftMargin,int width);//ӡ

void _FreeLine();
void _InPrint2dcode(char data[]);
void OnClosePort();
int  getSum(int &sum);
char* strmov(char *dest,const char *src,char ch);
vector<string> *split(const string &str, const string &sep);

void deletelog(int nDays);

//ǩӡ;
//򿪶˿;
//ÿӡһҳҪ;
int InitTscPort();
//windowӡһ;Ż;
//x				ӡx;
//y				ӡy;鴫0;
//font_size 	С;
//rotate		ѡǶ;
//				0 -> 0 degree
//				90-> 90 degree
//				180-> 180 degree
//				270-> 270 degree 
//font_type   0-> ׼(Normal);
//				1-> б(Italic);
//				2-> (Bold);
//				3-> б(Bold and Italic);
//high_len    һ֮ľ;ԶȻЧ;
//line			·Ƿע;
//font_name   ;΢źڵ;
//data			ӡ;
//font_ratio	ÿӦĺ; 0.0666665; Ϊ0ʱԶ;
int WinPrintlnTsc(int x, int y, int font_size, int rotate, int font_type, int high_len, int line, char *font_name, char *data, double font_ratio);
//ӡһҳ;ӡ;
//ÿӡһҳҪ;
int PrintCloseTsc(char *page, char *num);

#endif
