/*
 * Copyright (c) 2018  www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.firstboot.web;

import cn.freemud.firstboot.service.ProductService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api
@Controller
@RequestMapping("/page")
@Slf4j
public class ProductPageController {

    @Autowired
    private ProductService productService;

    @Resource(name = "defaultProductService")
    private ProductService defaultProductService;

    @ApiOperation(value = "创建产品", notes = "创建产品")
    @ApiImplicitParam(value = "请求", required = true, dataType = "String", name = "id")
    @GetMapping("/create")
    public String kafkaTest(Model model, String id) {
        model.addAttribute("id", id);
        return "product";
    }
}
