/*
 * Copyright (c) 2018  www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.firstboot.dao;

import cn.freemud.firstboot.vo.ProductCreateReq;
import cn.freemud.firstboot.vo.ProductResp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;

/**
 * @author qi.xu  2018/11/7 11:15
 */
@Slf4j
@Repository
public class ProductDao {

    private static final String PRODUCT_NAME = "产品名称";
    private static final String NEWID = "NEWID";

    /**
     *
     * @param id
     * @return
     */
    public ProductResp getById(String id) {
        ProductResp productResp = new ProductResp();
        productResp.setId(id);
        productResp.setProductName(id + PRODUCT_NAME);
        return productResp;
    }

    /**
     *
     * @param req
     * @return
     */
    public ProductResp create(ProductCreateReq req) {
        ProductResp productResp = new ProductResp();
        productResp.setId(NEWID);
        productResp.setProductName(req.getProductName());
        return productResp;
    }
}
