package com.spring.boot.controller;

import com.spring.boot.entity.Product;
import jdk.nashorn.internal.objects.annotations.Getter;
import jdk.nashorn.internal.objects.annotations.Setter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;

@Controller
public class ProductController {
    /***
     * 查询商品信息
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/GetProductInfo", method = RequestMethod.GET)
    @Getter
    public Product GetProductInfo() {
        Product product = new Product();
        product.Product_Id = 1;
        product.Product_Name = "鱼肉烧";
        product.Product_Price = new BigDecimal("10.00");
        product.Product_Num = 100;
        product.Product_Type = "食品类";
        product.Product_description = "吃得到的鱼肉味";

        return product;
    }







    /***
     * 增加商品信息
     * @param info
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/SetProductInfo", method = RequestMethod.POST)
    @Setter
    public boolean SetProductInfo(Product info) {
        boolean result = false;
        if (info != null) {
            Product product = new Product();
            product.Product_Id = info.Product_Id;
            product.Product_Name = info.Product_Name;
            product.Product_Price = info.Product_Price;
            product.Product_Num = info.Product_Num;
            product.Product_Type = info.Product_Type;
            product.Product_description = info.Product_description;
            result = true;
        }
        return result;
    }
}
