package com.spring.aop;

import org.aspectj.lang.annotation.*;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TestAop {

    @Pointcut("execution(public * com.spring.aop..*.add(..))")
    public void log(){};

    @Before("log()")
    public void before(){
        System.out.println("method before");
    }

    @After("log()")
    public void after(){
        System.out.println("method after");
    }

    @AfterReturning("execution(public * com.spring.aop..*.*(..))")
    public void AfterReturning(){
        System.out.println("method AfterReturning");
    }

    @AfterThrowing("execution(public * com.spring.aop..*.*(..))")
    public void AfterThrowing(){
        System.out.println("method AfterThrowing");
    }
}
