﻿#include "tasklogin.h"
#include "fmviplogin.h"
#include "fmp_vip_settings.h"
#include "fmnetwork.h"
#include <QJsonDocument>

TaskLogin::TaskLogin(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTask(jsonObj, FM_Login, session, parent)
{
}

TaskLogin::~TaskLogin()
{
    del_p(_window);
}

void TaskLogin::setWindow()
{
    _window = new FMVipLogin;

    connect(qobject_cast<FMVipLogin*>(_window), &FMVipLogin::login, this, &TaskLogin::onLogin);
    session()->addData("store_id", getPosJsonValue("store_id"));
    session()->addData("pos_id", getPosJsonValue("pos_id"));
    session()->addData("operator_id", getPosJsonValue("operator_id"));
    session()->addData("business_date", getPosJsonValue("business_date"));
}

void TaskLogin::packageServerReq()
{
    QJsonObject code;
    code[ServerProps(PosProps.Member_sign)] = session()->data(PosProps.Member_sign).toString();
    serverReqJsonObj["data"] = code;
}

void TaskLogin::packagePOSRsp()
{
    posRspJsonObj["statusCode"] = getServerJsonValue("statusCode").toInt();
    posRspJsonObj["msg"] = getServerJsonValue("msg").toString();
    posRspJsonObj["prompt"] = getServerJsonValue("prompt").toInt();
    posRspJsonObj["fm_open_id"] = getServerJsonValue(PosProps.Fm_open_id).toString();
    posRspJsonObj["account"] = getServerJsonValue("memberNo").toString();
    posRspJsonObj["type_code"] = getServerJsonValue("typecode").toString();
    posRspJsonObj["type_name"] = getServerJsonValue("typename").toString();
    posRspJsonObj["amount"] = getServerJsonValue("amount").toInt();
    posRspJsonObj["score"] = getServerJsonValue("score").toInt();
    posRspJsonObj["name"] = getServerJsonValue("name").toString();
    posRspJsonObj["sex"] = getServerJsonValue("sex").toString();
    posRspJsonObj["birthday"] = getServerJsonValue("birthday").toString();
    posRspJsonObj["phone"] = getServerJsonValue("mobile").toString();
    posRspJsonObj["address"] = getServerJsonValue("address").toString();
    posRspJsonObj["email"] = getServerJsonValue("email").toString();
    posRspJsonObj[PosProps.Member_sign] = session()->data(PosProps.Member_sign).toString();
}

void TaskLogin::onLogin()
{
    bool isOk = sendToServer();
    if(!isOk) {
        if(_window != nullptr) {
            _window->accept();
        }
        return;
    }

    // 认证失败
    if(getServerJsonValue("statusCode").toInt() != FM_API_SUCCESS) {
        QString info = serverRspJsonObj["msg"].toString();
        FMP_WARN() << "Login failed: " << info;
        FMMsgWnd::FailureWnd(info, _window);
    }
    // 认证成功
    else {
        QString account = getServerJsonValue(PosProps.Fm_open_id).toString();
        QString birthday = getServerJsonValue(PosProps.Birthday).toString();
        if(birthday.isEmpty()) {
            birthday = "--";
        }
        QString name = getServerJsonValue(PosProps.Name).toString();
        if(name.isEmpty()) {
            name = "--";
        }

        bool canPay = (getServerJsonValue(PosProps.CanPay).toInt() == 1);
#ifdef FM_DEBUG
        canPay = true;
#endif
        if(!canPay) {
            if(getPosJsonValue(PosProps.Fm_cmd).toInt() != FM_Pay) {
                FMMsgWnd::LoginSuccess(account, name, birthday, _window);
            } else {
                FMMsgWnd::FailureWnd(QString::fromLocal8Bit(ErrorNeedPayCode), _window);
                _window->resetWnd();
                return;
            }
        }

        session()->addData(PosProps.Name, name);
        session()->addData(PosProps.Birthday, birthday);
        session()->addData(PosProps.Fm_open_id, account);
        session()->addData(PosProps.Amount, getServerJsonValue(PosProps.Amount).toInt());
        session()->addData(PosProps.Score, getServerJsonValue(PosProps.Score).toInt());
        session()->addData(PosProps.CanPay, canPay);

        _window->accept();
    }
    if(_window!=nullptr) {
        _window->resetWnd();
    }
}
