﻿#ifndef SESSION_H
#define SESSION_H

#include <QVariant>
#include <QDateTime>
#include "global.h"
#include "coupon.h"

class Session
{
public:
    Session();
    Session(const Session& other) {
        this->_sessionDataMap = other.sessionDataMap();
    }

    ~Session();

    Session &operator =(const Session& other) {
        this->_sessionDataMap = other.sessionDataMap();
        return *this;
    }

    QVariant data(const QString key) const;

    void addData(const QString key, const QVariant value);
    void addData(const QString key, const QMap<QString, Coupon> couponMap);
    bool contains(const QString key) {return _sessionDataMap.contains(key);}
    QMap<QString, Coupon> getCouponMap(const QString key);

    QMap<QString, QVariant> sessionDataMap() const { return this->_sessionDataMap;}
    void setSessionDataMap(const QMap<QString, QVariant> &dataMap) {this->_sessionDataMap = dataMap;}

    // 清空Session
    void clear();
    void reset();

    // Session的创建时间
    QDateTime createdTime () { return _createdTime; }
    // 将Session的创建时间重置为当前时间
    void resetCreatedTime() {this->_createdTime = QDateTime::currentDateTime();}

private:
    QMap<QString, QVariant>  _sessionDataMap;
    QDateTime                _createdTime;
};

#endif // SESSION_H
