﻿#ifndef FMTASK_H
#define FMTASK_H
#include "fmvipwnd.h"
#include "fmmsgwnd.h"
#include "session.h"
#include <QObject>
#include <QJsonObject>
#include <QJsonArray>
#include <QDebug>

class FMTask : public QObject
{
    Q_OBJECT
public:
    explicit FMTask(QJsonObject &jsonObj, FM_TYPE fmType, Session *session = 0, QObject *parent = 0);
    ~FMTask();

    virtual QByteArray doTask();
    virtual void stopTask();

    void setFM_Type(const FM_TYPE fmType) {_FM_Type = fmType;}
    FM_TYPE FM_Type() const { return _FM_Type;}

    Session* session() const {return _session;}

    QJsonValue searchJsonValue(QJsonObject &searchJson, QString searchKey);
    QJsonValue getServerJsonValue(const QString prop);
    QJsonValue getPosJsonValue(const QString prop);

    bool getIsShowErrorMsgWnd() const;
    void setIsShowErrorMsgWnd(bool isShowErrorMsgWnd);
protected:
    // 从配置文件中拷贝数据信息
    void copyPros();
    virtual void setWindow(){}
    virtual void showWindow();
    virtual void packageServerReq() = 0;
    virtual bool sendToServer(bool isShowMsg = true);
    virtual void packagePOSRsp() = 0;

protected:
    QJsonObject posReqJsonObj;
    QJsonObject posRspJsonObj;
    QJsonObject serverReqJsonObj;
    QJsonObject serverRspJsonObj;
    FMVipWnd    *_window;
    Session     *_session;
    bool        isCreator;
    FM_TYPE     _FM_Type;

    QString     url;

    FMTask      *preTask;

    bool _isShowErrorMsgWnd;

private:
    QString sign() const;

 /**
 * @brief FMError
 * define error.
 */
typedef int FMError;
public:
    FMError error() const {return _error;}
    void setError(const FMError error)
    { _error = error; _errorMsg = "";}
    void setError(const FMError error, const QString errorMsg)
    { _error = error; _errorMsg = errorMsg;}
    void setError(const FMError error, const int errorCode, const QString errorMsg)
    { _error = error; _errorMsg = QString("[%1]%2").arg(errorCode).arg(errorMsg);}
    QString errorString() {
        if(fm_error.find(_error) == fm_error.end()) {
            return "Undefine Error";
        } else {
            if(_errorMsg != "")
                return _errorMsg;
            return fm_error.at(_error);
        }
    }

private:
    FMError _error;
    QString _errorMsg;
};

#endif // FMTASK_H
