﻿#include "coupon.h"
#include <QPainter>
#include <QPalette>
#include <QDebug>

const int PaintingWidth = 220;
const int PaintingHeight = 116;

Coupon::Coupon(QString name, QString code, QString type, double disAmount, double limitAmount, QString limitTime, bool isCompatible) :
    _name(name),
    _code(code),
    _type(type),
    _disAmount(disAmount),
    _limitAmount(limitAmount),
    _discountFactor(1),
    _isCompatible(isCompatible),
    _limitTime(limitTime)
{
}

void Coupon::paint(QPainter *painter, const QRect &rect, const QPalette &palette) const
{
    Q_UNUSED(palette);
    painter->save();

    painter->setRenderHint(QPainter::Antialiasing, true);

    // 白色背景
    painter->fillRect(rect, Qt::white);
    // 左边橘黄色矩形
    painter->fillRect(QRect(rect.x(), rect.y(), 5, rect.height()), QColor(255, 170, 37));
    int centerY = rect.y()+rect.height()/2;
    // 中间虚线
    painter->setPen(Qt::DotLine);
    painter->drawLine(rect.x()+10, centerY, rect.x()+rect.width()-10, centerY);
    // 抵扣金额
    QPen pen;
    pen.setColor(QColor(229, 11, 72));
    painter->setPen(pen);
    QFont font("Microsoft YaHei", 30, 500);
    painter->setFont(font);
    QString disStr;
    if(this->_type == "discount") {
        disStr = QString::fromLocal8Bit("%1折").arg(this->_discountFactor);
    } else {
        disStr = QString::number(this->_disAmount, 'f', 2);
    }
    QRect topRect(rect.x(), rect.y(), rect.width(), rect.height()/2);
    painter->drawText(topRect, Qt::AlignCenter, disStr);
    // ￥标识
    QString flagStr = QString::fromLocal8Bit("￥");
    int fontWidth = painter->fontMetrics().width(disStr);
    font.setPixelSize(11);
    painter->setFont(font);
    int flagWidth = painter->fontMetrics().width(flagStr);
    int flagHeight = painter->fontMetrics().height();
    if(this->_type != "discount")
    {
        painter->drawText(rect.x()+(rect.width()-fontWidth)/2-flagWidth, topRect.center().y()+flagHeight, flagStr);
    }
    // 满额条件
    pen.setColor(QColor(127,127,127));
    painter->setPen(pen);
    font.setPixelSize(10);
    font.setWeight(1);
    painter->setFont(font);
    QRect limitRect(rect.x(), rect.y(), rect.width(), rect.height()-flagHeight);
    QString limitStr = QString::fromLocal8Bit("满 %1 元可用").arg(this->limitAmount());
    painter->drawText(limitRect, Qt::AlignCenter, limitStr);

    // 优惠券名
    font.setPixelSize(15);
    painter->setFont(font);
    pen.setColor(Qt::white);
    painter->setPen(pen);
    fontWidth = painter->fontMetrics().width(this->_name)+20;
    int fontHeight = painter->fontMetrics().height();
    QRect nameRect(rect.x()+(rect.width()-fontWidth)/2, centerY+10, fontWidth, fontHeight);
    painter->fillRect(nameRect, QColor(229, 11, 72));
    painter->drawText(nameRect, Qt::AlignCenter, this->_name);
    // 券码
    font.setPixelSize(12);
    painter->setFont(font);
    pen.setColor(QColor(127,127,127));
    painter->setPen(pen);
    fontHeight = painter->fontMetrics().height();
    QRect codeRect(rect.x(), rect.y()+rect.height()-fontHeight-5, rect.width(), fontHeight);
    painter->drawText(codeRect, Qt::AlignCenter, this->_limitTime);

    painter->restore();
}

QSize Coupon::sizeHint() const
{
    return QSize(PaintingWidth, PaintingHeight);
}
